/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceGroupByField {
    ACCOUNT_ID("AccountId"),
    REGION("Region"),
    RESOURCE_CATEGORY("ResourceCategory"),
    RESOURCE_TYPE("ResourceType"),
    RESOURCE_NAME("ResourceName"),
    FINDINGS_SUMMARY_FINDING_TYPE("FindingsSummary.FindingType"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceGroupByField> VALUE_MAP;
    private final String value;

    private ResourceGroupByField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceGroupByField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceGroupByField> knownValues() {
        EnumSet<ResourceGroupByField> knownValues = EnumSet.allOf(ResourceGroupByField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceGroupByField.class, ResourceGroupByField::toString);
    }
}

