/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.GroupByValue;
import software.amazon.awssdk.services.securityhub.model.GroupByValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupByResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupByResult> {
    private static final SdkField<String> GROUP_BY_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupByField").getter(GroupByResult.getter(GroupByResult::groupByField)).setter(GroupByResult.setter(Builder::groupByField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByField").build()}).build();
    private static final SdkField<List<GroupByValue>> GROUP_BY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupByValues").getter(GroupByResult.getter(GroupByResult::groupByValues)).setter(GroupByResult.setter(Builder::groupByValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupByValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD_FIELD, GROUP_BY_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupByResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupByField;
    private final List<GroupByValue> groupByValues;

    private GroupByResult(BuilderImpl builder) {
        this.groupByField = builder.groupByField;
        this.groupByValues = builder.groupByValues;
    }

    public final String groupByField() {
        return this.groupByField;
    }

    public final boolean hasGroupByValues() {
        return this.groupByValues != null && !(this.groupByValues instanceof SdkAutoConstructList);
    }

    public final List<GroupByValue> groupByValues() {
        return this.groupByValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByValues() ? this.groupByValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupByResult)) {
            return false;
        }
        GroupByResult other = (GroupByResult)obj;
        return Objects.equals(this.groupByField(), other.groupByField()) && this.hasGroupByValues() == other.hasGroupByValues() && Objects.equals(this.groupByValues(), other.groupByValues());
    }

    public final String toString() {
        return ToString.builder((String)"GroupByResult").add("GroupByField", (Object)this.groupByField()).add("GroupByValues", this.hasGroupByValues() ? this.groupByValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupByField": {
                return Optional.ofNullable(clazz.cast(this.groupByField()));
            }
            case "GroupByValues": {
                return Optional.ofNullable(clazz.cast(this.groupByValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupByField", GROUP_BY_FIELD_FIELD);
        map.put("GroupByValues", GROUP_BY_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupByResult, T> g) {
        return obj -> g.apply((GroupByResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupByField;
        private List<GroupByValue> groupByValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupByResult model) {
            this.groupByField(model.groupByField);
            this.groupByValues(model.groupByValues);
        }

        public final String getGroupByField() {
            return this.groupByField;
        }

        public final void setGroupByField(String groupByField) {
            this.groupByField = groupByField;
        }

        @Override
        public final Builder groupByField(String groupByField) {
            this.groupByField = groupByField;
            return this;
        }

        public final List<GroupByValue.Builder> getGroupByValues() {
            List<GroupByValue.Builder> result = GroupByValuesCopier.copyToBuilder(this.groupByValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByValues(Collection<GroupByValue.BuilderImpl> groupByValues) {
            this.groupByValues = GroupByValuesCopier.copyFromBuilder(groupByValues);
        }

        @Override
        public final Builder groupByValues(Collection<GroupByValue> groupByValues) {
            this.groupByValues = GroupByValuesCopier.copy(groupByValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByValues(GroupByValue ... groupByValues) {
            this.groupByValues(Arrays.asList(groupByValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByValues(Consumer<GroupByValue.Builder> ... groupByValues) {
            this.groupByValues(Stream.of(groupByValues).map(c -> (GroupByValue)((GroupByValue.Builder)GroupByValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GroupByResult build() {
            return new GroupByResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupByResult> {
        public Builder groupByField(String var1);

        public Builder groupByValues(Collection<GroupByValue> var1);

        public Builder groupByValues(GroupByValue ... var1);

        public Builder groupByValues(Consumer<GroupByValue.Builder> ... var1);
    }
}

