/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ResourceGroupByRule;
import software.amazon.awssdk.services.securityhub.model.ResourceGroupByRulesCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesStatisticsV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, GetResourcesStatisticsV2Request> {
    private static final SdkField<List<ResourceGroupByRule>> GROUP_BY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupByRules").getter(GetResourcesStatisticsV2Request.getter(GetResourcesStatisticsV2Request::groupByRules)).setter(GetResourcesStatisticsV2Request.setter(Builder::groupByRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceGroupByRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(GetResourcesStatisticsV2Request.getter(GetResourcesStatisticsV2Request::sortOrderAsString)).setter(GetResourcesStatisticsV2Request.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<Integer> MAX_STATISTIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxStatisticResults").getter(GetResourcesStatisticsV2Request.getter(GetResourcesStatisticsV2Request::maxStatisticResults)).setter(GetResourcesStatisticsV2Request.setter(Builder::maxStatisticResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStatisticResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_RULES_FIELD, SORT_ORDER_FIELD, MAX_STATISTIC_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourcesStatisticsV2Request.memberNameToFieldInitializer();
    private final List<ResourceGroupByRule> groupByRules;
    private final String sortOrder;
    private final Integer maxStatisticResults;

    private GetResourcesStatisticsV2Request(BuilderImpl builder) {
        super(builder);
        this.groupByRules = builder.groupByRules;
        this.sortOrder = builder.sortOrder;
        this.maxStatisticResults = builder.maxStatisticResults;
    }

    public final boolean hasGroupByRules() {
        return this.groupByRules != null && !(this.groupByRules instanceof SdkAutoConstructList);
    }

    public final List<ResourceGroupByRule> groupByRules() {
        return this.groupByRules;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final Integer maxStatisticResults() {
        return this.maxStatisticResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByRules() ? this.groupByRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStatisticResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesStatisticsV2Request)) {
            return false;
        }
        GetResourcesStatisticsV2Request other = (GetResourcesStatisticsV2Request)((Object)obj);
        return this.hasGroupByRules() == other.hasGroupByRules() && Objects.equals(this.groupByRules(), other.groupByRules()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.maxStatisticResults(), other.maxStatisticResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcesStatisticsV2Request").add("GroupByRules", this.hasGroupByRules() ? this.groupByRules() : null).add("SortOrder", (Object)this.sortOrderAsString()).add("MaxStatisticResults", (Object)this.maxStatisticResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupByRules": {
                return Optional.ofNullable(clazz.cast(this.groupByRules()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "MaxStatisticResults": {
                return Optional.ofNullable(clazz.cast(this.maxStatisticResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupByRules", GROUP_BY_RULES_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("MaxStatisticResults", MAX_STATISTIC_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesStatisticsV2Request, T> g) {
        return obj -> g.apply((GetResourcesStatisticsV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<ResourceGroupByRule> groupByRules = DefaultSdkAutoConstructList.getInstance();
        private String sortOrder;
        private Integer maxStatisticResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesStatisticsV2Request model) {
            super(model);
            this.groupByRules(model.groupByRules);
            this.sortOrder(model.sortOrder);
            this.maxStatisticResults(model.maxStatisticResults);
        }

        public final List<ResourceGroupByRule.Builder> getGroupByRules() {
            List<ResourceGroupByRule.Builder> result = ResourceGroupByRulesCopier.copyToBuilder(this.groupByRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByRules(Collection<ResourceGroupByRule.BuilderImpl> groupByRules) {
            this.groupByRules = ResourceGroupByRulesCopier.copyFromBuilder(groupByRules);
        }

        @Override
        public final Builder groupByRules(Collection<ResourceGroupByRule> groupByRules) {
            this.groupByRules = ResourceGroupByRulesCopier.copy(groupByRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByRules(ResourceGroupByRule ... groupByRules) {
            this.groupByRules(Arrays.asList(groupByRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByRules(Consumer<ResourceGroupByRule.Builder> ... groupByRules) {
            this.groupByRules(Stream.of(groupByRules).map(c -> (ResourceGroupByRule)((ResourceGroupByRule.Builder)ResourceGroupByRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Integer getMaxStatisticResults() {
            return this.maxStatisticResults;
        }

        public final void setMaxStatisticResults(Integer maxStatisticResults) {
            this.maxStatisticResults = maxStatisticResults;
        }

        @Override
        public final Builder maxStatisticResults(Integer maxStatisticResults) {
            this.maxStatisticResults = maxStatisticResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesStatisticsV2Request build() {
            return new GetResourcesStatisticsV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesStatisticsV2Request> {
        public Builder groupByRules(Collection<ResourceGroupByRule> var1);

        public Builder groupByRules(ResourceGroupByRule ... var1);

        public Builder groupByRules(Consumer<ResourceGroupByRule.Builder> ... var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder maxStatisticResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

