/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.HealthCheck;
import software.amazon.awssdk.services.securityhub.model.ProviderDetail;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectorV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetConnectorV2Response> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorArn").getter(GetConnectorV2Response.getter(GetConnectorV2Response::connectorArn)).setter(GetConnectorV2Response.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()}).build();
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(GetConnectorV2Response.getter(GetConnectorV2Response::connectorId)).setter(GetConnectorV2Response.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetConnectorV2Response.getter(GetConnectorV2Response::name)).setter(GetConnectorV2Response.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetConnectorV2Response.getter(GetConnectorV2Response::description)).setter(GetConnectorV2Response.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(GetConnectorV2Response.getter(GetConnectorV2Response::kmsKeyArn)).setter(GetConnectorV2Response.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetConnectorV2Response.getter(GetConnectorV2Response::createdAt)).setter(GetConnectorV2Response.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetConnectorV2Response.getter(GetConnectorV2Response::lastUpdatedAt)).setter(GetConnectorV2Response.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<HealthCheck> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Health").getter(GetConnectorV2Response.getter(GetConnectorV2Response::health)).setter(GetConnectorV2Response.setter(Builder::health)).constructor(HealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Health").build()}).build();
    private static final SdkField<ProviderDetail> PROVIDER_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProviderDetail").getter(GetConnectorV2Response.getter(GetConnectorV2Response::providerDetail)).setter(GetConnectorV2Response.setter(Builder::providerDetail)).constructor(ProviderDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD, CONNECTOR_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, KMS_KEY_ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, HEALTH_FIELD, PROVIDER_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConnectorV2Response.memberNameToFieldInitializer();
    private final String connectorArn;
    private final String connectorId;
    private final String name;
    private final String description;
    private final String kmsKeyArn;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final HealthCheck health;
    private final ProviderDetail providerDetail;

    private GetConnectorV2Response(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorId = builder.connectorId;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.health = builder.health;
        this.providerDetail = builder.providerDetail;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final HealthCheck health() {
        return this.health;
    }

    public final ProviderDetail providerDetail() {
        return this.providerDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.health());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorV2Response)) {
            return false;
        }
        GetConnectorV2Response other = (GetConnectorV2Response)((Object)obj);
        return Objects.equals(this.connectorArn(), other.connectorArn()) && Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.health(), other.health()) && Objects.equals(this.providerDetail(), other.providerDetail());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectorV2Response").add("ConnectorArn", (Object)this.connectorArn()).add("ConnectorId", (Object)this.connectorId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Health", (Object)this.health()).add("ProviderDetail", (Object)this.providerDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Health": {
                return Optional.ofNullable(clazz.cast(this.health()));
            }
            case "ProviderDetail": {
                return Optional.ofNullable(clazz.cast(this.providerDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorArn", CONNECTOR_ARN_FIELD);
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Health", HEALTH_FIELD);
        map.put("ProviderDetail", PROVIDER_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectorV2Response, T> g) {
        return obj -> g.apply((GetConnectorV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String connectorArn;
        private String connectorId;
        private String name;
        private String description;
        private String kmsKeyArn;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private HealthCheck health;
        private ProviderDetail providerDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorV2Response model) {
            super(model);
            this.connectorArn(model.connectorArn);
            this.connectorId(model.connectorId);
            this.name(model.name);
            this.description(model.description);
            this.kmsKeyArn(model.kmsKeyArn);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.health(model.health);
            this.providerDetail(model.providerDetail);
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final HealthCheck.Builder getHealth() {
            return this.health != null ? this.health.toBuilder() : null;
        }

        public final void setHealth(HealthCheck.BuilderImpl health) {
            this.health = health != null ? health.build() : null;
        }

        @Override
        public final Builder health(HealthCheck health) {
            this.health = health;
            return this;
        }

        public final ProviderDetail.Builder getProviderDetail() {
            return this.providerDetail != null ? this.providerDetail.toBuilder() : null;
        }

        public final void setProviderDetail(ProviderDetail.BuilderImpl providerDetail) {
            this.providerDetail = providerDetail != null ? providerDetail.build() : null;
        }

        @Override
        public final Builder providerDetail(ProviderDetail providerDetail) {
            this.providerDetail = providerDetail;
            return this;
        }

        @Override
        public GetConnectorV2Response build() {
            return new GetConnectorV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectorV2Response> {
        public Builder connectorArn(String var1);

        public Builder connectorId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder health(HealthCheck var1);

        default public Builder health(Consumer<HealthCheck.Builder> health) {
            return this.health((HealthCheck)((HealthCheck.Builder)HealthCheck.builder().applyMutation(health)).build());
        }

        public Builder providerDetail(ProviderDetail var1);

        default public Builder providerDetail(Consumer<ProviderDetail.Builder> providerDetail) {
            return this.providerDetail((ProviderDetail)((ProviderDetail.Builder)ProviderDetail.builder().applyMutation(providerDetail)).build());
        }
    }
}

