/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ConnectorStatus;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConnectorV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, CreateConnectorV2Response> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorArn").getter(CreateConnectorV2Response.getter(CreateConnectorV2Response::connectorArn)).setter(CreateConnectorV2Response.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()}).build();
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(CreateConnectorV2Response.getter(CreateConnectorV2Response::connectorId)).setter(CreateConnectorV2Response.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> AUTH_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthUrl").getter(CreateConnectorV2Response.getter(CreateConnectorV2Response::authUrl)).setter(CreateConnectorV2Response.setter(Builder::authUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthUrl").build()}).build();
    private static final SdkField<String> CONNECTOR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorStatus").getter(CreateConnectorV2Response.getter(CreateConnectorV2Response::connectorStatusAsString)).setter(CreateConnectorV2Response.setter(Builder::connectorStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD, CONNECTOR_ID_FIELD, AUTH_URL_FIELD, CONNECTOR_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateConnectorV2Response.memberNameToFieldInitializer();
    private final String connectorArn;
    private final String connectorId;
    private final String authUrl;
    private final String connectorStatus;

    private CreateConnectorV2Response(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorId = builder.connectorId;
        this.authUrl = builder.authUrl;
        this.connectorStatus = builder.connectorStatus;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String authUrl() {
        return this.authUrl;
    }

    public final ConnectorStatus connectorStatus() {
        return ConnectorStatus.fromValue(this.connectorStatus);
    }

    public final String connectorStatusAsString() {
        return this.connectorStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorV2Response)) {
            return false;
        }
        CreateConnectorV2Response other = (CreateConnectorV2Response)((Object)obj);
        return Objects.equals(this.connectorArn(), other.connectorArn()) && Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.authUrl(), other.authUrl()) && Objects.equals(this.connectorStatusAsString(), other.connectorStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConnectorV2Response").add("ConnectorArn", (Object)this.connectorArn()).add("ConnectorId", (Object)this.connectorId()).add("AuthUrl", (Object)this.authUrl()).add("ConnectorStatus", (Object)this.connectorStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "AuthUrl": {
                return Optional.ofNullable(clazz.cast(this.authUrl()));
            }
            case "ConnectorStatus": {
                return Optional.ofNullable(clazz.cast(this.connectorStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectorArn", CONNECTOR_ARN_FIELD);
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("AuthUrl", AUTH_URL_FIELD);
        map.put("ConnectorStatus", CONNECTOR_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorV2Response, T> g) {
        return obj -> g.apply((CreateConnectorV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String connectorArn;
        private String connectorId;
        private String authUrl;
        private String connectorStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorV2Response model) {
            super(model);
            this.connectorArn(model.connectorArn);
            this.connectorId(model.connectorId);
            this.authUrl(model.authUrl);
            this.connectorStatus(model.connectorStatus);
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getAuthUrl() {
            return this.authUrl;
        }

        public final void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @Override
        public final Builder authUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public final String getConnectorStatus() {
            return this.connectorStatus;
        }

        public final void setConnectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
        }

        @Override
        public final Builder connectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
            return this;
        }

        @Override
        public final Builder connectorStatus(ConnectorStatus connectorStatus) {
            this.connectorStatus(connectorStatus == null ? null : connectorStatus.toString());
            return this;
        }

        @Override
        public CreateConnectorV2Response build() {
            return new CreateConnectorV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConnectorV2Response> {
        public Builder connectorArn(String var1);

        public Builder connectorId(String var1);

        public Builder authUrl(String var1);

        public Builder connectorStatus(String var1);

        public Builder connectorStatus(ConnectorStatus var1);
    }
}

