/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionListV2Copier;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionV2;
import software.amazon.awssdk.services.securityhub.model.Criteria;
import software.amazon.awssdk.services.securityhub.model.RuleStatusV2;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAutomationRuleV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, CreateAutomationRuleV2Request> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::ruleName)).setter(CreateAutomationRuleV2Request.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleStatus").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::ruleStatusAsString)).setter(CreateAutomationRuleV2Request.setter(Builder::ruleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::description)).setter(CreateAutomationRuleV2Request.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Float> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("RuleOrder").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::ruleOrder)).setter(CreateAutomationRuleV2Request.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<Criteria> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Criteria").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::criteria)).setter(CreateAutomationRuleV2Request.setter(Builder::criteria)).constructor(Criteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()}).build();
    private static final SdkField<List<AutomationRulesActionV2>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::actions)).setter(CreateAutomationRuleV2Request.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesActionV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::tags)).setter(CreateAutomationRuleV2Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateAutomationRuleV2Request.getter(CreateAutomationRuleV2Request::clientToken)).setter(CreateAutomationRuleV2Request.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_STATUS_FIELD, DESCRIPTION_FIELD, RULE_ORDER_FIELD, CRITERIA_FIELD, ACTIONS_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAutomationRuleV2Request.memberNameToFieldInitializer();
    private final String ruleName;
    private final String ruleStatus;
    private final String description;
    private final Float ruleOrder;
    private final Criteria criteria;
    private final List<AutomationRulesActionV2> actions;
    private final Map<String, String> tags;
    private final String clientToken;

    private CreateAutomationRuleV2Request(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleStatus = builder.ruleStatus;
        this.description = builder.description;
        this.ruleOrder = builder.ruleOrder;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final RuleStatusV2 ruleStatus() {
        return RuleStatusV2.fromValue(this.ruleStatus);
    }

    public final String ruleStatusAsString() {
        return this.ruleStatus;
    }

    public final String description() {
        return this.description;
    }

    public final Float ruleOrder() {
        return this.ruleOrder;
    }

    public final Criteria criteria() {
        return this.criteria;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesActionV2> actions() {
        return this.actions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutomationRuleV2Request)) {
            return false;
        }
        CreateAutomationRuleV2Request other = (CreateAutomationRuleV2Request)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleStatusAsString(), other.ruleStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ruleOrder(), other.ruleOrder()) && Objects.equals(this.criteria(), other.criteria()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAutomationRuleV2Request").add("RuleName", (Object)this.ruleName()).add("RuleStatus", (Object)this.ruleStatusAsString()).add("Description", (Object)this.description()).add("RuleOrder", (Object)this.ruleOrder()).add("Criteria", (Object)this.criteria()).add("Actions", this.hasActions() ? this.actions() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrder()));
            }
            case "Criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("RuleStatus", RULE_STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("Criteria", CRITERIA_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutomationRuleV2Request, T> g) {
        return obj -> g.apply((CreateAutomationRuleV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String ruleName;
        private String ruleStatus;
        private String description;
        private Float ruleOrder;
        private Criteria criteria;
        private List<AutomationRulesActionV2> actions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutomationRuleV2Request model) {
            super(model);
            this.ruleName(model.ruleName);
            this.ruleStatus(model.ruleStatus);
            this.description(model.description);
            this.ruleOrder(model.ruleOrder);
            this.criteria(model.criteria);
            this.actions(model.actions);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleStatus() {
            return this.ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatusV2 ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Float getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final Criteria.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(Criteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(Criteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesActionV2.Builder> getActions() {
            List<AutomationRulesActionV2.Builder> result = AutomationRulesActionListV2Copier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesActionV2.BuilderImpl> actions) {
            this.actions = AutomationRulesActionListV2Copier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesActionV2> actions) {
            this.actions = AutomationRulesActionListV2Copier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesActionV2 ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesActionV2.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (AutomationRulesActionV2)((AutomationRulesActionV2.Builder)AutomationRulesActionV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutomationRuleV2Request build() {
            return new CreateAutomationRuleV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAutomationRuleV2Request> {
        public Builder ruleName(String var1);

        public Builder ruleStatus(String var1);

        public Builder ruleStatus(RuleStatusV2 var1);

        public Builder description(String var1);

        public Builder ruleOrder(Float var1);

        public Builder criteria(Criteria var1);

        default public Builder criteria(Consumer<Criteria.Builder> criteria) {
            return this.criteria((Criteria)((Criteria.Builder)Criteria.builder().applyMutation(criteria)).build());
        }

        public Builder actions(Collection<AutomationRulesActionV2> var1);

        public Builder actions(AutomationRulesActionV2 ... var1);

        public Builder actions(Consumer<AutomationRulesActionV2.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

