/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeRepositoryDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeRepositoryDetails> {
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(CodeRepositoryDetails.getter(CodeRepositoryDetails::providerType)).setter(CodeRepositoryDetails.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(CodeRepositoryDetails.getter(CodeRepositoryDetails::projectName)).setter(CodeRepositoryDetails.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> CODE_SECURITY_INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSecurityIntegrationArn").getter(CodeRepositoryDetails.getter(CodeRepositoryDetails::codeSecurityIntegrationArn)).setter(CodeRepositoryDetails.setter(Builder::codeSecurityIntegrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSecurityIntegrationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPE_FIELD, PROJECT_NAME_FIELD, CODE_SECURITY_INTEGRATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeRepositoryDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String providerType;
    private final String projectName;
    private final String codeSecurityIntegrationArn;

    private CodeRepositoryDetails(BuilderImpl builder) {
        this.providerType = builder.providerType;
        this.projectName = builder.projectName;
        this.codeSecurityIntegrationArn = builder.codeSecurityIntegrationArn;
    }

    public final String providerType() {
        return this.providerType;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String codeSecurityIntegrationArn() {
        return this.codeSecurityIntegrationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSecurityIntegrationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryDetails)) {
            return false;
        }
        CodeRepositoryDetails other = (CodeRepositoryDetails)obj;
        return Objects.equals(this.providerType(), other.providerType()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.codeSecurityIntegrationArn(), other.codeSecurityIntegrationArn());
    }

    public final String toString() {
        return ToString.builder((String)"CodeRepositoryDetails").add("ProviderType", (Object)this.providerType()).add("ProjectName", (Object)this.projectName()).add("CodeSecurityIntegrationArn", (Object)this.codeSecurityIntegrationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerType()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "CodeSecurityIntegrationArn": {
                return Optional.ofNullable(clazz.cast(this.codeSecurityIntegrationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("ProjectName", PROJECT_NAME_FIELD);
        map.put("CodeSecurityIntegrationArn", CODE_SECURITY_INTEGRATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryDetails, T> g) {
        return obj -> g.apply((CodeRepositoryDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerType;
        private String projectName;
        private String codeSecurityIntegrationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryDetails model) {
            this.providerType(model.providerType);
            this.projectName(model.projectName);
            this.codeSecurityIntegrationArn(model.codeSecurityIntegrationArn);
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getCodeSecurityIntegrationArn() {
            return this.codeSecurityIntegrationArn;
        }

        public final void setCodeSecurityIntegrationArn(String codeSecurityIntegrationArn) {
            this.codeSecurityIntegrationArn = codeSecurityIntegrationArn;
        }

        @Override
        public final Builder codeSecurityIntegrationArn(String codeSecurityIntegrationArn) {
            this.codeSecurityIntegrationArn = codeSecurityIntegrationArn;
            return this;
        }

        public CodeRepositoryDetails build() {
            return new CodeRepositoryDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeRepositoryDetails> {
        public Builder providerType(String var1);

        public Builder projectName(String var1);

        public Builder codeSecurityIntegrationArn(String var1);
    }
}

