/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request;
import software.amazon.awssdk.services.securityhub.model.GetResourcesV2Response;
import software.amazon.awssdk.services.securityhub.model.ResourceResult;

public class GetResourcesV2Iterable
implements SdkIterable<GetResourcesV2Response> {
    private final SecurityHubClient client;
    private final GetResourcesV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourcesV2Iterable(SecurityHubClient client, GetResourcesV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetResourcesV2ResponseFetcher();
    }

    public Iterator<GetResourcesV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceResult> resources() {
        Function<GetResourcesV2Response, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetResourcesV2ResponseFetcher
    implements SyncPageFetcher<GetResourcesV2Response> {
        private GetResourcesV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourcesV2Response nextPage(GetResourcesV2Response previousPage) {
            if (previousPage == null) {
                return GetResourcesV2Iterable.this.client.getResourcesV2(GetResourcesV2Iterable.this.firstRequest);
            }
            return GetResourcesV2Iterable.this.client.getResourcesV2((GetResourcesV2Request)((Object)GetResourcesV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

