/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationUpdate;
import software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnprocessedStandardsControlAssociationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnprocessedStandardsControlAssociationUpdate> {
    private static final SdkField<StandardsControlAssociationUpdate> STANDARDS_CONTROL_ASSOCIATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StandardsControlAssociationUpdate").getter(UnprocessedStandardsControlAssociationUpdate.getter(UnprocessedStandardsControlAssociationUpdate::standardsControlAssociationUpdate)).setter(UnprocessedStandardsControlAssociationUpdate.setter(Builder::standardsControlAssociationUpdate)).constructor(StandardsControlAssociationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationUpdate").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(UnprocessedStandardsControlAssociationUpdate.getter(UnprocessedStandardsControlAssociationUpdate::errorCodeAsString)).setter(UnprocessedStandardsControlAssociationUpdate.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorReason").getter(UnprocessedStandardsControlAssociationUpdate.getter(UnprocessedStandardsControlAssociationUpdate::errorReason)).setter(UnprocessedStandardsControlAssociationUpdate.setter(Builder::errorReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ASSOCIATION_UPDATE_FIELD, ERROR_CODE_FIELD, ERROR_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnprocessedStandardsControlAssociationUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final StandardsControlAssociationUpdate standardsControlAssociationUpdate;
    private final String errorCode;
    private final String errorReason;

    private UnprocessedStandardsControlAssociationUpdate(BuilderImpl builder) {
        this.standardsControlAssociationUpdate = builder.standardsControlAssociationUpdate;
        this.errorCode = builder.errorCode;
        this.errorReason = builder.errorReason;
    }

    public final StandardsControlAssociationUpdate standardsControlAssociationUpdate() {
        return this.standardsControlAssociationUpdate;
    }

    public final UnprocessedErrorCode errorCode() {
        return UnprocessedErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorReason() {
        return this.errorReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsControlAssociationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedStandardsControlAssociationUpdate)) {
            return false;
        }
        UnprocessedStandardsControlAssociationUpdate other = (UnprocessedStandardsControlAssociationUpdate)obj;
        return Objects.equals(this.standardsControlAssociationUpdate(), other.standardsControlAssociationUpdate()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorReason(), other.errorReason());
    }

    public final String toString() {
        return ToString.builder((String)"UnprocessedStandardsControlAssociationUpdate").add("StandardsControlAssociationUpdate", (Object)this.standardsControlAssociationUpdate()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorReason", (Object)this.errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsControlAssociationUpdate": {
                return Optional.ofNullable(clazz.cast(this.standardsControlAssociationUpdate()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorReason": {
                return Optional.ofNullable(clazz.cast(this.errorReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StandardsControlAssociationUpdate", STANDARDS_CONTROL_ASSOCIATION_UPDATE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorReason", ERROR_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedStandardsControlAssociationUpdate, T> g) {
        return obj -> g.apply((UnprocessedStandardsControlAssociationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StandardsControlAssociationUpdate standardsControlAssociationUpdate;
        private String errorCode;
        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedStandardsControlAssociationUpdate model) {
            this.standardsControlAssociationUpdate(model.standardsControlAssociationUpdate);
            this.errorCode(model.errorCode);
            this.errorReason(model.errorReason);
        }

        public final StandardsControlAssociationUpdate.Builder getStandardsControlAssociationUpdate() {
            return this.standardsControlAssociationUpdate != null ? this.standardsControlAssociationUpdate.toBuilder() : null;
        }

        public final void setStandardsControlAssociationUpdate(StandardsControlAssociationUpdate.BuilderImpl standardsControlAssociationUpdate) {
            this.standardsControlAssociationUpdate = standardsControlAssociationUpdate != null ? standardsControlAssociationUpdate.build() : null;
        }

        @Override
        public final Builder standardsControlAssociationUpdate(StandardsControlAssociationUpdate standardsControlAssociationUpdate) {
            this.standardsControlAssociationUpdate = standardsControlAssociationUpdate;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UnprocessedErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorReason() {
            return this.errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public UnprocessedStandardsControlAssociationUpdate build() {
            return new UnprocessedStandardsControlAssociationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnprocessedStandardsControlAssociationUpdate> {
        public Builder standardsControlAssociationUpdate(StandardsControlAssociationUpdate var1);

        default public Builder standardsControlAssociationUpdate(Consumer<StandardsControlAssociationUpdate.Builder> standardsControlAssociationUpdate) {
            return this.standardsControlAssociationUpdate((StandardsControlAssociationUpdate)((StandardsControlAssociationUpdate.Builder)StandardsControlAssociationUpdate.builder().applyMutation(standardsControlAssociationUpdate)).build());
        }

        public Builder errorCode(String var1);

        public Builder errorCode(UnprocessedErrorCode var1);

        public Builder errorReason(String var1);
    }
}

