/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.UnprocessedErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnprocessedSecurityControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnprocessedSecurityControl> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlId").getter(UnprocessedSecurityControl.getter(UnprocessedSecurityControl::securityControlId)).setter(UnprocessedSecurityControl.setter(Builder::securityControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(UnprocessedSecurityControl.getter(UnprocessedSecurityControl::errorCodeAsString)).setter(UnprocessedSecurityControl.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorReason").getter(UnprocessedSecurityControl.getter(UnprocessedSecurityControl::errorReason)).setter(UnprocessedSecurityControl.setter(Builder::errorReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD, ERROR_CODE_FIELD, ERROR_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnprocessedSecurityControl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String securityControlId;
    private final String errorCode;
    private final String errorReason;

    private UnprocessedSecurityControl(BuilderImpl builder) {
        this.securityControlId = builder.securityControlId;
        this.errorCode = builder.errorCode;
        this.errorReason = builder.errorReason;
    }

    public final String securityControlId() {
        return this.securityControlId;
    }

    public final UnprocessedErrorCode errorCode() {
        return UnprocessedErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorReason() {
        return this.errorReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedSecurityControl)) {
            return false;
        }
        UnprocessedSecurityControl other = (UnprocessedSecurityControl)obj;
        return Objects.equals(this.securityControlId(), other.securityControlId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorReason(), other.errorReason());
    }

    public final String toString() {
        return ToString.builder((String)"UnprocessedSecurityControl").add("SecurityControlId", (Object)this.securityControlId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorReason", (Object)this.errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityControlId": {
                return Optional.ofNullable(clazz.cast(this.securityControlId()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorReason": {
                return Optional.ofNullable(clazz.cast(this.errorReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("ErrorReason", ERROR_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnprocessedSecurityControl, T> g) {
        return obj -> g.apply((UnprocessedSecurityControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String securityControlId;
        private String errorCode;
        private String errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedSecurityControl model) {
            this.securityControlId(model.securityControlId);
            this.errorCode(model.errorCode);
            this.errorReason(model.errorReason);
        }

        public final String getSecurityControlId() {
            return this.securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(UnprocessedErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorReason() {
            return this.errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public UnprocessedSecurityControl build() {
            return new UnprocessedSecurityControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnprocessedSecurityControl> {
        public Builder securityControlId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(UnprocessedErrorCode var1);

        public Builder errorReason(String var1);
    }
}

