/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SensitiveDataDetections;
import software.amazon.awssdk.services.securityhub.model.SensitiveDataDetectionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SensitiveDataResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SensitiveDataResult> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(SensitiveDataResult.getter(SensitiveDataResult::category)).setter(SensitiveDataResult.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<List<SensitiveDataDetections>> DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Detections").getter(SensitiveDataResult.getter(SensitiveDataResult::detections)).setter(SensitiveDataResult.setter(Builder::detections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SensitiveDataDetections::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCount").getter(SensitiveDataResult.getter(SensitiveDataResult::totalCount)).setter(SensitiveDataResult.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, DETECTIONS_FIELD, TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SensitiveDataResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String category;
    private final List<SensitiveDataDetections> detections;
    private final Long totalCount;

    private SensitiveDataResult(BuilderImpl builder) {
        this.category = builder.category;
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    public final String category() {
        return this.category;
    }

    public final boolean hasDetections() {
        return this.detections != null && !(this.detections instanceof SdkAutoConstructList);
    }

    public final List<SensitiveDataDetections> detections() {
        return this.detections;
    }

    public final Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetections() ? this.detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensitiveDataResult)) {
            return false;
        }
        SensitiveDataResult other = (SensitiveDataResult)obj;
        return Objects.equals(this.category(), other.category()) && this.hasDetections() == other.hasDetections() && Objects.equals(this.detections(), other.detections()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SensitiveDataResult").add("Category", (Object)this.category()).add("Detections", this.hasDetections() ? this.detections() : null).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Detections": {
                return Optional.ofNullable(clazz.cast(this.detections()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Category", CATEGORY_FIELD);
        map.put("Detections", DETECTIONS_FIELD);
        map.put("TotalCount", TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SensitiveDataResult, T> g) {
        return obj -> g.apply((SensitiveDataResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private List<SensitiveDataDetections> detections = DefaultSdkAutoConstructList.getInstance();
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SensitiveDataResult model) {
            this.category(model.category);
            this.detections(model.detections);
            this.totalCount(model.totalCount);
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final List<SensitiveDataDetections.Builder> getDetections() {
            List<SensitiveDataDetections.Builder> result = SensitiveDataDetectionsListCopier.copyToBuilder(this.detections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetections(Collection<SensitiveDataDetections.BuilderImpl> detections) {
            this.detections = SensitiveDataDetectionsListCopier.copyFromBuilder(detections);
        }

        @Override
        public final Builder detections(Collection<SensitiveDataDetections> detections) {
            this.detections = SensitiveDataDetectionsListCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(SensitiveDataDetections ... detections) {
            this.detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<SensitiveDataDetections.Builder> ... detections) {
            this.detections(Stream.of(detections).map(c -> (SensitiveDataDetections)((SensitiveDataDetections.Builder)SensitiveDataDetections.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public SensitiveDataResult build() {
            return new SensitiveDataResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SensitiveDataResult> {
        public Builder category(String var1);

        public Builder detections(Collection<SensitiveDataDetections> var1);

        public Builder detections(SensitiveDataDetections ... var1);

        public Builder detections(Consumer<SensitiveDataDetections.Builder> ... var1);

        public Builder totalCount(Long var1);
    }
}

