/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ConnectorProviderName;
import software.amazon.awssdk.services.securityhub.model.ConnectorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProviderSummary> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderName").getter(ProviderSummary.getter(ProviderSummary::providerNameAsString)).setter(ProviderSummary.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()}).build();
    private static final SdkField<String> CONNECTOR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorStatus").getter(ProviderSummary.getter(ProviderSummary::connectorStatusAsString)).setter(ProviderSummary.setter(Builder::connectorStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD, CONNECTOR_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProviderSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String providerName;
    private final String connectorStatus;

    private ProviderSummary(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.connectorStatus = builder.connectorStatus;
    }

    public final ConnectorProviderName providerName() {
        return ConnectorProviderName.fromValue(this.providerName);
    }

    public final String providerNameAsString() {
        return this.providerName;
    }

    public final ConnectorStatus connectorStatus() {
        return ConnectorStatus.fromValue(this.connectorStatus);
    }

    public final String connectorStatusAsString() {
        return this.connectorStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderSummary)) {
            return false;
        }
        ProviderSummary other = (ProviderSummary)obj;
        return Objects.equals(this.providerNameAsString(), other.providerNameAsString()) && Objects.equals(this.connectorStatusAsString(), other.connectorStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProviderSummary").add("ProviderName", (Object)this.providerNameAsString()).add("ConnectorStatus", (Object)this.connectorStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerNameAsString()));
            }
            case "ConnectorStatus": {
                return Optional.ofNullable(clazz.cast(this.connectorStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("ConnectorStatus", CONNECTOR_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderSummary, T> g) {
        return obj -> g.apply((ProviderSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerName;
        private String connectorStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderSummary model) {
            this.providerName(model.providerName);
            this.connectorStatus(model.connectorStatus);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        @Override
        public final Builder providerName(ConnectorProviderName providerName) {
            this.providerName(providerName == null ? null : providerName.toString());
            return this;
        }

        public final String getConnectorStatus() {
            return this.connectorStatus;
        }

        public final void setConnectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
        }

        @Override
        public final Builder connectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
            return this;
        }

        @Override
        public final Builder connectorStatus(ConnectorStatus connectorStatus) {
            this.connectorStatus(connectorStatus == null ? null : connectorStatus.toString());
            return this;
        }

        public ProviderSummary build() {
            return new ProviderSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProviderSummary> {
        public Builder providerName(String var1);

        public Builder providerName(ConnectorProviderName var1);

        public Builder connectorStatus(String var1);

        public Builder connectorStatus(ConnectorStatus var1);
    }
}

