/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.CategoryListCopier;
import software.amazon.awssdk.services.securityhub.model.IntegrationV2Type;
import software.amazon.awssdk.services.securityhub.model.IntegrationV2TypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductV2> {
    private static final SdkField<String> PRODUCT_V2_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductV2Name").getter(ProductV2.getter(ProductV2::productV2Name)).setter(ProductV2.setter(Builder::productV2Name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductV2Name").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(ProductV2.getter(ProductV2::companyName)).setter(ProductV2.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ProductV2.getter(ProductV2::description)).setter(ProductV2.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(ProductV2.getter(ProductV2::categories)).setter(ProductV2.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INTEGRATION_V2_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegrationV2Types").getter(ProductV2.getter(ProductV2::integrationV2TypesAsStrings)).setter(ProductV2.setter(Builder::integrationV2TypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationV2Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKETPLACE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MarketplaceUrl").getter(ProductV2.getter(ProductV2::marketplaceUrl)).setter(ProductV2.setter(Builder::marketplaceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceUrl").build()}).build();
    private static final SdkField<String> ACTIVATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationUrl").getter(ProductV2.getter(ProductV2::activationUrl)).setter(ProductV2.setter(Builder::activationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_V2_NAME_FIELD, COMPANY_NAME_FIELD, DESCRIPTION_FIELD, CATEGORIES_FIELD, INTEGRATION_V2_TYPES_FIELD, MARKETPLACE_URL_FIELD, ACTIVATION_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProductV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String productV2Name;
    private final String companyName;
    private final String description;
    private final List<String> categories;
    private final List<String> integrationV2Types;
    private final String marketplaceUrl;
    private final String activationUrl;

    private ProductV2(BuilderImpl builder) {
        this.productV2Name = builder.productV2Name;
        this.companyName = builder.companyName;
        this.description = builder.description;
        this.categories = builder.categories;
        this.integrationV2Types = builder.integrationV2Types;
        this.marketplaceUrl = builder.marketplaceUrl;
        this.activationUrl = builder.activationUrl;
    }

    public final String productV2Name() {
        return this.productV2Name;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categories() {
        return this.categories;
    }

    public final List<IntegrationV2Type> integrationV2Types() {
        return IntegrationV2TypeListCopier.copyStringToEnum(this.integrationV2Types);
    }

    public final boolean hasIntegrationV2Types() {
        return this.integrationV2Types != null && !(this.integrationV2Types instanceof SdkAutoConstructList);
    }

    public final List<String> integrationV2TypesAsStrings() {
        return this.integrationV2Types;
    }

    public final String marketplaceUrl() {
        return this.marketplaceUrl;
    }

    public final String activationUrl() {
        return this.activationUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productV2Name());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrationV2Types() ? this.integrationV2TypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplaceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductV2)) {
            return false;
        }
        ProductV2 other = (ProductV2)obj;
        return Objects.equals(this.productV2Name(), other.productV2Name()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.description(), other.description()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && this.hasIntegrationV2Types() == other.hasIntegrationV2Types() && Objects.equals(this.integrationV2TypesAsStrings(), other.integrationV2TypesAsStrings()) && Objects.equals(this.marketplaceUrl(), other.marketplaceUrl()) && Objects.equals(this.activationUrl(), other.activationUrl());
    }

    public final String toString() {
        return ToString.builder((String)"ProductV2").add("ProductV2Name", (Object)this.productV2Name()).add("CompanyName", (Object)this.companyName()).add("Description", (Object)this.description()).add("Categories", this.hasCategories() ? this.categories() : null).add("IntegrationV2Types", this.hasIntegrationV2Types() ? this.integrationV2TypesAsStrings() : null).add("MarketplaceUrl", (Object)this.marketplaceUrl()).add("ActivationUrl", (Object)this.activationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductV2Name": {
                return Optional.ofNullable(clazz.cast(this.productV2Name()));
            }
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "IntegrationV2Types": {
                return Optional.ofNullable(clazz.cast(this.integrationV2TypesAsStrings()));
            }
            case "MarketplaceUrl": {
                return Optional.ofNullable(clazz.cast(this.marketplaceUrl()));
            }
            case "ActivationUrl": {
                return Optional.ofNullable(clazz.cast(this.activationUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProductV2Name", PRODUCT_V2_NAME_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Categories", CATEGORIES_FIELD);
        map.put("IntegrationV2Types", INTEGRATION_V2_TYPES_FIELD);
        map.put("MarketplaceUrl", MARKETPLACE_URL_FIELD);
        map.put("ActivationUrl", ACTIVATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProductV2, T> g) {
        return obj -> g.apply((ProductV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productV2Name;
        private String companyName;
        private String description;
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private List<String> integrationV2Types = DefaultSdkAutoConstructList.getInstance();
        private String marketplaceUrl;
        private String activationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductV2 model) {
            this.productV2Name(model.productV2Name);
            this.companyName(model.companyName);
            this.description(model.description);
            this.categories(model.categories);
            this.integrationV2TypesWithStrings(model.integrationV2Types);
            this.marketplaceUrl(model.marketplaceUrl);
            this.activationUrl(model.activationUrl);
        }

        public final String getProductV2Name() {
            return this.productV2Name;
        }

        public final void setProductV2Name(String productV2Name) {
            this.productV2Name = productV2Name;
        }

        @Override
        public final Builder productV2Name(String productV2Name) {
            this.productV2Name = productV2Name;
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
        }

        @Override
        public final Builder categories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categories(String ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final Collection<String> getIntegrationV2Types() {
            if (this.integrationV2Types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integrationV2Types;
        }

        public final void setIntegrationV2Types(Collection<String> integrationV2Types) {
            this.integrationV2Types = IntegrationV2TypeListCopier.copy(integrationV2Types);
        }

        @Override
        public final Builder integrationV2TypesWithStrings(Collection<String> integrationV2Types) {
            this.integrationV2Types = IntegrationV2TypeListCopier.copy(integrationV2Types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationV2TypesWithStrings(String ... integrationV2Types) {
            this.integrationV2TypesWithStrings(Arrays.asList(integrationV2Types));
            return this;
        }

        @Override
        public final Builder integrationV2Types(Collection<IntegrationV2Type> integrationV2Types) {
            this.integrationV2Types = IntegrationV2TypeListCopier.copyEnumToString(integrationV2Types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationV2Types(IntegrationV2Type ... integrationV2Types) {
            this.integrationV2Types(Arrays.asList(integrationV2Types));
            return this;
        }

        public final String getMarketplaceUrl() {
            return this.marketplaceUrl;
        }

        public final void setMarketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
        }

        @Override
        public final Builder marketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
            return this;
        }

        public final String getActivationUrl() {
            return this.activationUrl;
        }

        public final void setActivationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
        }

        @Override
        public final Builder activationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
            return this;
        }

        public ProductV2 build() {
            return new ProductV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductV2> {
        public Builder productV2Name(String var1);

        public Builder companyName(String var1);

        public Builder description(String var1);

        public Builder categories(Collection<String> var1);

        public Builder categories(String ... var1);

        public Builder integrationV2TypesWithStrings(Collection<String> var1);

        public Builder integrationV2TypesWithStrings(String ... var1);

        public Builder integrationV2Types(Collection<IntegrationV2Type> var1);

        public Builder integrationV2Types(IntegrationV2Type ... var1);

        public Builder marketplaceUrl(String var1);

        public Builder activationUrl(String var1);
    }
}

