/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfBooleanField {
    COMPLIANCE_ASSESSMENTS_MEETS_CRITERIA("compliance.assessments.meets_criteria"),
    VULNERABILITIES_IS_EXPLOIT_AVAILABLE("vulnerabilities.is_exploit_available"),
    VULNERABILITIES_IS_FIX_AVAILABLE("vulnerabilities.is_fix_available"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfBooleanField> VALUE_MAP;
    private final String value;

    private OcsfBooleanField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfBooleanField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfBooleanField> knownValues() {
        EnumSet<OcsfBooleanField> knownValues = EnumSet.allOf(OcsfBooleanField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfBooleanField.class, OcsfBooleanField::toString);
    }
}

