/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifierListCopier;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFinding;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsUnprocessedFindingsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateFindingsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchUpdateFindingsResponse> {
    private static final SdkField<List<AwsSecurityFindingIdentifier>> PROCESSED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessedFindings").getter(BatchUpdateFindingsResponse.getter(BatchUpdateFindingsResponse::processedFindings)).setter(BatchUpdateFindingsResponse.setter(Builder::processedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsSecurityFindingIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchUpdateFindingsUnprocessedFinding>> UNPROCESSED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedFindings").getter(BatchUpdateFindingsResponse.getter(BatchUpdateFindingsResponse::unprocessedFindings)).setter(BatchUpdateFindingsResponse.setter(Builder::unprocessedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateFindingsUnprocessedFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_FINDINGS_FIELD, UNPROCESSED_FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateFindingsResponse.memberNameToFieldInitializer();
    private final List<AwsSecurityFindingIdentifier> processedFindings;
    private final List<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings;

    private BatchUpdateFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.processedFindings = builder.processedFindings;
        this.unprocessedFindings = builder.unprocessedFindings;
    }

    public final boolean hasProcessedFindings() {
        return this.processedFindings != null && !(this.processedFindings instanceof SdkAutoConstructList);
    }

    public final List<AwsSecurityFindingIdentifier> processedFindings() {
        return this.processedFindings;
    }

    public final boolean hasUnprocessedFindings() {
        return this.unprocessedFindings != null && !(this.unprocessedFindings instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings() {
        return this.unprocessedFindings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessedFindings() ? this.processedFindings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedFindings() ? this.unprocessedFindings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsResponse)) {
            return false;
        }
        BatchUpdateFindingsResponse other = (BatchUpdateFindingsResponse)((Object)obj);
        return this.hasProcessedFindings() == other.hasProcessedFindings() && Objects.equals(this.processedFindings(), other.processedFindings()) && this.hasUnprocessedFindings() == other.hasUnprocessedFindings() && Objects.equals(this.unprocessedFindings(), other.unprocessedFindings());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateFindingsResponse").add("ProcessedFindings", this.hasProcessedFindings() ? this.processedFindings() : null).add("UnprocessedFindings", this.hasUnprocessedFindings() ? this.unprocessedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessedFindings": {
                return Optional.ofNullable(clazz.cast(this.processedFindings()));
            }
            case "UnprocessedFindings": {
                return Optional.ofNullable(clazz.cast(this.unprocessedFindings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProcessedFindings", PROCESSED_FINDINGS_FIELD);
        map.put("UnprocessedFindings", UNPROCESSED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsResponse, T> g) {
        return obj -> g.apply((BatchUpdateFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<AwsSecurityFindingIdentifier> processedFindings = DefaultSdkAutoConstructList.getInstance();
        private List<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsResponse model) {
            super(model);
            this.processedFindings(model.processedFindings);
            this.unprocessedFindings(model.unprocessedFindings);
        }

        public final List<AwsSecurityFindingIdentifier.Builder> getProcessedFindings() {
            List<AwsSecurityFindingIdentifier.Builder> result = AwsSecurityFindingIdentifierListCopier.copyToBuilder(this.processedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessedFindings(Collection<AwsSecurityFindingIdentifier.BuilderImpl> processedFindings) {
            this.processedFindings = AwsSecurityFindingIdentifierListCopier.copyFromBuilder(processedFindings);
        }

        @Override
        public final Builder processedFindings(Collection<AwsSecurityFindingIdentifier> processedFindings) {
            this.processedFindings = AwsSecurityFindingIdentifierListCopier.copy(processedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(AwsSecurityFindingIdentifier ... processedFindings) {
            this.processedFindings(Arrays.asList(processedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedFindings(Consumer<AwsSecurityFindingIdentifier.Builder> ... processedFindings) {
            this.processedFindings(Stream.of(processedFindings).map(c -> (AwsSecurityFindingIdentifier)((AwsSecurityFindingIdentifier.Builder)AwsSecurityFindingIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateFindingsUnprocessedFinding.Builder> getUnprocessedFindings() {
            List<BatchUpdateFindingsUnprocessedFinding.Builder> result = BatchUpdateFindingsUnprocessedFindingsListCopier.copyToBuilder(this.unprocessedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding.BuilderImpl> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsUnprocessedFindingsListCopier.copyFromBuilder(unprocessedFindings);
        }

        @Override
        public final Builder unprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding> unprocessedFindings) {
            this.unprocessedFindings = BatchUpdateFindingsUnprocessedFindingsListCopier.copy(unprocessedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(BatchUpdateFindingsUnprocessedFinding ... unprocessedFindings) {
            this.unprocessedFindings(Arrays.asList(unprocessedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedFindings(Consumer<BatchUpdateFindingsUnprocessedFinding.Builder> ... unprocessedFindings) {
            this.unprocessedFindings(Stream.of(unprocessedFindings).map(c -> (BatchUpdateFindingsUnprocessedFinding)((BatchUpdateFindingsUnprocessedFinding.Builder)BatchUpdateFindingsUnprocessedFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateFindingsResponse build() {
            return new BatchUpdateFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateFindingsResponse> {
        public Builder processedFindings(Collection<AwsSecurityFindingIdentifier> var1);

        public Builder processedFindings(AwsSecurityFindingIdentifier ... var1);

        public Builder processedFindings(Consumer<AwsSecurityFindingIdentifier.Builder> ... var1);

        public Builder unprocessedFindings(Collection<BatchUpdateFindingsUnprocessedFinding> var1);

        public Builder unprocessedFindings(BatchUpdateFindingsUnprocessedFinding ... var1);

        public Builder unprocessedFindings(Consumer<BatchUpdateFindingsUnprocessedFinding.Builder> ... var1);
    }
}

