/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAccessLog;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAdditionalAttribute;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAdditionalAttributeListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionDraining;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElbLoadBalancerAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElbLoadBalancerAttributes> {
    private static final SdkField<AwsElbLoadBalancerAccessLog> ACCESS_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessLog").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::accessLog)).setter(AwsElbLoadBalancerAttributes.setter(Builder::accessLog)).constructor(AwsElbLoadBalancerAccessLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLog").build()}).build();
    private static final SdkField<AwsElbLoadBalancerConnectionDraining> CONNECTION_DRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionDraining").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::connectionDraining)).setter(AwsElbLoadBalancerAttributes.setter(Builder::connectionDraining)).constructor(AwsElbLoadBalancerConnectionDraining::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDraining").build()}).build();
    private static final SdkField<AwsElbLoadBalancerConnectionSettings> CONNECTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionSettings").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::connectionSettings)).setter(AwsElbLoadBalancerAttributes.setter(Builder::connectionSettings)).constructor(AwsElbLoadBalancerConnectionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSettings").build()}).build();
    private static final SdkField<AwsElbLoadBalancerCrossZoneLoadBalancing> CROSS_ZONE_LOAD_BALANCING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CrossZoneLoadBalancing").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::crossZoneLoadBalancing)).setter(AwsElbLoadBalancerAttributes.setter(Builder::crossZoneLoadBalancing)).constructor(AwsElbLoadBalancerCrossZoneLoadBalancing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossZoneLoadBalancing").build()}).build();
    private static final SdkField<List<AwsElbLoadBalancerAdditionalAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalAttributes").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::additionalAttributes)).setter(AwsElbLoadBalancerAttributes.setter(Builder::additionalAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElbLoadBalancerAdditionalAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_FIELD, CONNECTION_DRAINING_FIELD, CONNECTION_SETTINGS_FIELD, CROSS_ZONE_LOAD_BALANCING_FIELD, ADDITIONAL_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsElbLoadBalancerAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AwsElbLoadBalancerAccessLog accessLog;
    private final AwsElbLoadBalancerConnectionDraining connectionDraining;
    private final AwsElbLoadBalancerConnectionSettings connectionSettings;
    private final AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing;
    private final List<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes;

    private AwsElbLoadBalancerAttributes(BuilderImpl builder) {
        this.accessLog = builder.accessLog;
        this.connectionDraining = builder.connectionDraining;
        this.connectionSettings = builder.connectionSettings;
        this.crossZoneLoadBalancing = builder.crossZoneLoadBalancing;
        this.additionalAttributes = builder.additionalAttributes;
    }

    public final AwsElbLoadBalancerAccessLog accessLog() {
        return this.accessLog;
    }

    public final AwsElbLoadBalancerConnectionDraining connectionDraining() {
        return this.connectionDraining;
    }

    public final AwsElbLoadBalancerConnectionSettings connectionSettings() {
        return this.connectionSettings;
    }

    public final AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing() {
        return this.crossZoneLoadBalancing;
    }

    public final boolean hasAdditionalAttributes() {
        return this.additionalAttributes != null && !(this.additionalAttributes instanceof SdkAutoConstructList);
    }

    public final List<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes() {
        return this.additionalAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionDraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossZoneLoadBalancing());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributes() ? this.additionalAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerAttributes)) {
            return false;
        }
        AwsElbLoadBalancerAttributes other = (AwsElbLoadBalancerAttributes)obj;
        return Objects.equals(this.accessLog(), other.accessLog()) && Objects.equals(this.connectionDraining(), other.connectionDraining()) && Objects.equals(this.connectionSettings(), other.connectionSettings()) && Objects.equals(this.crossZoneLoadBalancing(), other.crossZoneLoadBalancing()) && this.hasAdditionalAttributes() == other.hasAdditionalAttributes() && Objects.equals(this.additionalAttributes(), other.additionalAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElbLoadBalancerAttributes").add("AccessLog", (Object)this.accessLog()).add("ConnectionDraining", (Object)this.connectionDraining()).add("ConnectionSettings", (Object)this.connectionSettings()).add("CrossZoneLoadBalancing", (Object)this.crossZoneLoadBalancing()).add("AdditionalAttributes", this.hasAdditionalAttributes() ? this.additionalAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessLog": {
                return Optional.ofNullable(clazz.cast(this.accessLog()));
            }
            case "ConnectionDraining": {
                return Optional.ofNullable(clazz.cast(this.connectionDraining()));
            }
            case "ConnectionSettings": {
                return Optional.ofNullable(clazz.cast(this.connectionSettings()));
            }
            case "CrossZoneLoadBalancing": {
                return Optional.ofNullable(clazz.cast(this.crossZoneLoadBalancing()));
            }
            case "AdditionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessLog", ACCESS_LOG_FIELD);
        map.put("ConnectionDraining", CONNECTION_DRAINING_FIELD);
        map.put("ConnectionSettings", CONNECTION_SETTINGS_FIELD);
        map.put("CrossZoneLoadBalancing", CROSS_ZONE_LOAD_BALANCING_FIELD);
        map.put("AdditionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerAttributes, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsElbLoadBalancerAccessLog accessLog;
        private AwsElbLoadBalancerConnectionDraining connectionDraining;
        private AwsElbLoadBalancerConnectionSettings connectionSettings;
        private AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing;
        private List<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerAttributes model) {
            this.accessLog(model.accessLog);
            this.connectionDraining(model.connectionDraining);
            this.connectionSettings(model.connectionSettings);
            this.crossZoneLoadBalancing(model.crossZoneLoadBalancing);
            this.additionalAttributes(model.additionalAttributes);
        }

        public final AwsElbLoadBalancerAccessLog.Builder getAccessLog() {
            return this.accessLog != null ? this.accessLog.toBuilder() : null;
        }

        public final void setAccessLog(AwsElbLoadBalancerAccessLog.BuilderImpl accessLog) {
            this.accessLog = accessLog != null ? accessLog.build() : null;
        }

        @Override
        public final Builder accessLog(AwsElbLoadBalancerAccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        public final AwsElbLoadBalancerConnectionDraining.Builder getConnectionDraining() {
            return this.connectionDraining != null ? this.connectionDraining.toBuilder() : null;
        }

        public final void setConnectionDraining(AwsElbLoadBalancerConnectionDraining.BuilderImpl connectionDraining) {
            this.connectionDraining = connectionDraining != null ? connectionDraining.build() : null;
        }

        @Override
        public final Builder connectionDraining(AwsElbLoadBalancerConnectionDraining connectionDraining) {
            this.connectionDraining = connectionDraining;
            return this;
        }

        public final AwsElbLoadBalancerConnectionSettings.Builder getConnectionSettings() {
            return this.connectionSettings != null ? this.connectionSettings.toBuilder() : null;
        }

        public final void setConnectionSettings(AwsElbLoadBalancerConnectionSettings.BuilderImpl connectionSettings) {
            this.connectionSettings = connectionSettings != null ? connectionSettings.build() : null;
        }

        @Override
        public final Builder connectionSettings(AwsElbLoadBalancerConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        public final AwsElbLoadBalancerCrossZoneLoadBalancing.Builder getCrossZoneLoadBalancing() {
            return this.crossZoneLoadBalancing != null ? this.crossZoneLoadBalancing.toBuilder() : null;
        }

        public final void setCrossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing.BuilderImpl crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing != null ? crossZoneLoadBalancing.build() : null;
        }

        @Override
        public final Builder crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing;
            return this;
        }

        public final List<AwsElbLoadBalancerAdditionalAttribute.Builder> getAdditionalAttributes() {
            List<AwsElbLoadBalancerAdditionalAttribute.Builder> result = AwsElbLoadBalancerAdditionalAttributeListCopier.copyToBuilder(this.additionalAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAttributes(Collection<AwsElbLoadBalancerAdditionalAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AwsElbLoadBalancerAdditionalAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Collection<AwsElbLoadBalancerAdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = AwsElbLoadBalancerAdditionalAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AwsElbLoadBalancerAdditionalAttribute ... additionalAttributes) {
            this.additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AwsElbLoadBalancerAdditionalAttribute.Builder> ... additionalAttributes) {
            this.additionalAttributes(Stream.of(additionalAttributes).map(c -> (AwsElbLoadBalancerAdditionalAttribute)((AwsElbLoadBalancerAdditionalAttribute.Builder)AwsElbLoadBalancerAdditionalAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsElbLoadBalancerAttributes build() {
            return new AwsElbLoadBalancerAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElbLoadBalancerAttributes> {
        public Builder accessLog(AwsElbLoadBalancerAccessLog var1);

        default public Builder accessLog(Consumer<AwsElbLoadBalancerAccessLog.Builder> accessLog) {
            return this.accessLog((AwsElbLoadBalancerAccessLog)((AwsElbLoadBalancerAccessLog.Builder)AwsElbLoadBalancerAccessLog.builder().applyMutation(accessLog)).build());
        }

        public Builder connectionDraining(AwsElbLoadBalancerConnectionDraining var1);

        default public Builder connectionDraining(Consumer<AwsElbLoadBalancerConnectionDraining.Builder> connectionDraining) {
            return this.connectionDraining((AwsElbLoadBalancerConnectionDraining)((AwsElbLoadBalancerConnectionDraining.Builder)AwsElbLoadBalancerConnectionDraining.builder().applyMutation(connectionDraining)).build());
        }

        public Builder connectionSettings(AwsElbLoadBalancerConnectionSettings var1);

        default public Builder connectionSettings(Consumer<AwsElbLoadBalancerConnectionSettings.Builder> connectionSettings) {
            return this.connectionSettings((AwsElbLoadBalancerConnectionSettings)((AwsElbLoadBalancerConnectionSettings.Builder)AwsElbLoadBalancerConnectionSettings.builder().applyMutation(connectionSettings)).build());
        }

        public Builder crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing var1);

        default public Builder crossZoneLoadBalancing(Consumer<AwsElbLoadBalancerCrossZoneLoadBalancing.Builder> crossZoneLoadBalancing) {
            return this.crossZoneLoadBalancing((AwsElbLoadBalancerCrossZoneLoadBalancing)((AwsElbLoadBalancerCrossZoneLoadBalancing.Builder)AwsElbLoadBalancerCrossZoneLoadBalancing.builder().applyMutation(crossZoneLoadBalancing)).build());
        }

        public Builder additionalAttributes(Collection<AwsElbLoadBalancerAdditionalAttribute> var1);

        public Builder additionalAttributes(AwsElbLoadBalancerAdditionalAttribute ... var1);

        public Builder additionalAttributes(Consumer<AwsElbLoadBalancerAdditionalAttribute.Builder> ... var1);
    }
}

