/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclAssociation;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclAssociationListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclEntry;
import software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2NetworkAclDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2NetworkAclDetails> {
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(AwsEc2NetworkAclDetails.getter(AwsEc2NetworkAclDetails::isDefault)).setter(AwsEc2NetworkAclDetails.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkAclId").getter(AwsEc2NetworkAclDetails.getter(AwsEc2NetworkAclDetails::networkAclId)).setter(AwsEc2NetworkAclDetails.setter(Builder::networkAclId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(AwsEc2NetworkAclDetails.getter(AwsEc2NetworkAclDetails::ownerId)).setter(AwsEc2NetworkAclDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsEc2NetworkAclDetails.getter(AwsEc2NetworkAclDetails::vpcId)).setter(AwsEc2NetworkAclDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<AwsEc2NetworkAclAssociation>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(AwsEc2NetworkAclDetails.getter(AwsEc2NetworkAclDetails::associations)).setter(AwsEc2NetworkAclDetails.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2NetworkAclAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEc2NetworkAclEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(AwsEc2NetworkAclDetails.getter(AwsEc2NetworkAclDetails::entries)).setter(AwsEc2NetworkAclDetails.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2NetworkAclEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_DEFAULT_FIELD, NETWORK_ACL_ID_FIELD, OWNER_ID_FIELD, VPC_ID_FIELD, ASSOCIATIONS_FIELD, ENTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEc2NetworkAclDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean isDefault;
    private final String networkAclId;
    private final String ownerId;
    private final String vpcId;
    private final List<AwsEc2NetworkAclAssociation> associations;
    private final List<AwsEc2NetworkAclEntry> entries;

    private AwsEc2NetworkAclDetails(BuilderImpl builder) {
        this.isDefault = builder.isDefault;
        this.networkAclId = builder.networkAclId;
        this.ownerId = builder.ownerId;
        this.vpcId = builder.vpcId;
        this.associations = builder.associations;
        this.entries = builder.entries;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final String networkAclId() {
        return this.networkAclId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2NetworkAclAssociation> associations() {
        return this.associations;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2NetworkAclEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2NetworkAclDetails)) {
            return false;
        }
        AwsEc2NetworkAclDetails other = (AwsEc2NetworkAclDetails)obj;
        return Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.networkAclId(), other.networkAclId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2NetworkAclDetails").add("IsDefault", (Object)this.isDefault()).add("NetworkAclId", (Object)this.networkAclId()).add("OwnerId", (Object)this.ownerId()).add("VpcId", (Object)this.vpcId()).add("Associations", this.hasAssociations() ? this.associations() : null).add("Entries", this.hasEntries() ? this.entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "NetworkAclId": {
                return Optional.ofNullable(clazz.cast(this.networkAclId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("NetworkAclId", NETWORK_ACL_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("Associations", ASSOCIATIONS_FIELD);
        map.put("Entries", ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2NetworkAclDetails, T> g) {
        return obj -> g.apply((AwsEc2NetworkAclDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isDefault;
        private String networkAclId;
        private String ownerId;
        private String vpcId;
        private List<AwsEc2NetworkAclAssociation> associations = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEc2NetworkAclEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2NetworkAclDetails model) {
            this.isDefault(model.isDefault);
            this.networkAclId(model.networkAclId);
            this.ownerId(model.ownerId);
            this.vpcId(model.vpcId);
            this.associations(model.associations);
            this.entries(model.entries);
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<AwsEc2NetworkAclAssociation.Builder> getAssociations() {
            List<AwsEc2NetworkAclAssociation.Builder> result = AwsEc2NetworkAclAssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<AwsEc2NetworkAclAssociation.BuilderImpl> associations) {
            this.associations = AwsEc2NetworkAclAssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<AwsEc2NetworkAclAssociation> associations) {
            this.associations = AwsEc2NetworkAclAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(AwsEc2NetworkAclAssociation ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<AwsEc2NetworkAclAssociation.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (AwsEc2NetworkAclAssociation)((AwsEc2NetworkAclAssociation.Builder)AwsEc2NetworkAclAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEc2NetworkAclEntry.Builder> getEntries() {
            List<AwsEc2NetworkAclEntry.Builder> result = AwsEc2NetworkAclEntryListCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<AwsEc2NetworkAclEntry.BuilderImpl> entries) {
            this.entries = AwsEc2NetworkAclEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<AwsEc2NetworkAclEntry> entries) {
            this.entries = AwsEc2NetworkAclEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(AwsEc2NetworkAclEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<AwsEc2NetworkAclEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (AwsEc2NetworkAclEntry)((AwsEc2NetworkAclEntry.Builder)AwsEc2NetworkAclEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsEc2NetworkAclDetails build() {
            return new AwsEc2NetworkAclDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2NetworkAclDetails> {
        public Builder isDefault(Boolean var1);

        public Builder networkAclId(String var1);

        public Builder ownerId(String var1);

        public Builder vpcId(String var1);

        public Builder associations(Collection<AwsEc2NetworkAclAssociation> var1);

        public Builder associations(AwsEc2NetworkAclAssociation ... var1);

        public Builder associations(Consumer<AwsEc2NetworkAclAssociation.Builder> ... var1);

        public Builder entries(Collection<AwsEc2NetworkAclEntry> var1);

        public Builder entries(AwsEc2NetworkAclEntry ... var1);

        public Builder entries(Consumer<AwsEc2NetworkAclEntry.Builder> ... var1);
    }
}

