/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginCustomOriginConfig;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginS3OriginConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionOriginItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionOriginItem> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::domainName)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::id)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ORIGIN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginPath").getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::originPath)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::originPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginPath").build()}).build();
    private static final SdkField<AwsCloudFrontDistributionOriginS3OriginConfig> S3_ORIGIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3OriginConfig").getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::s3OriginConfig)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::s3OriginConfig)).constructor(AwsCloudFrontDistributionOriginS3OriginConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OriginConfig").build()}).build();
    private static final SdkField<AwsCloudFrontDistributionOriginCustomOriginConfig> CUSTOM_ORIGIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomOriginConfig").getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::customOriginConfig)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::customOriginConfig)).constructor(AwsCloudFrontDistributionOriginCustomOriginConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomOriginConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ID_FIELD, ORIGIN_PATH_FIELD, S3_ORIGIN_CONFIG_FIELD, CUSTOM_ORIGIN_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsCloudFrontDistributionOriginItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String id;
    private final String originPath;
    private final AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig;
    private final AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig;

    private AwsCloudFrontDistributionOriginItem(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.originPath = builder.originPath;
        this.s3OriginConfig = builder.s3OriginConfig;
        this.customOriginConfig = builder.customOriginConfig;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String id() {
        return this.id;
    }

    public final String originPath() {
        return this.originPath;
    }

    public final AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig() {
        return this.s3OriginConfig;
    }

    public final AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig() {
        return this.customOriginConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.originPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OriginConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.customOriginConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginItem)) {
            return false;
        }
        AwsCloudFrontDistributionOriginItem other = (AwsCloudFrontDistributionOriginItem)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.originPath(), other.originPath()) && Objects.equals(this.s3OriginConfig(), other.s3OriginConfig()) && Objects.equals(this.customOriginConfig(), other.customOriginConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionOriginItem").add("DomainName", (Object)this.domainName()).add("Id", (Object)this.id()).add("OriginPath", (Object)this.originPath()).add("S3OriginConfig", (Object)this.s3OriginConfig()).add("CustomOriginConfig", (Object)this.customOriginConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OriginPath": {
                return Optional.ofNullable(clazz.cast(this.originPath()));
            }
            case "S3OriginConfig": {
                return Optional.ofNullable(clazz.cast(this.s3OriginConfig()));
            }
            case "CustomOriginConfig": {
                return Optional.ofNullable(clazz.cast(this.customOriginConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("OriginPath", ORIGIN_PATH_FIELD);
        map.put("S3OriginConfig", S3_ORIGIN_CONFIG_FIELD);
        map.put("CustomOriginConfig", CUSTOM_ORIGIN_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginItem, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String id;
        private String originPath;
        private AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig;
        private AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginItem model) {
            this.domainName(model.domainName);
            this.id(model.id);
            this.originPath(model.originPath);
            this.s3OriginConfig(model.s3OriginConfig);
            this.customOriginConfig(model.customOriginConfig);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOriginPath() {
            return this.originPath;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final AwsCloudFrontDistributionOriginS3OriginConfig.Builder getS3OriginConfig() {
            return this.s3OriginConfig != null ? this.s3OriginConfig.toBuilder() : null;
        }

        public final void setS3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig.BuilderImpl s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig != null ? s3OriginConfig.build() : null;
        }

        @Override
        public final Builder s3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig;
            return this;
        }

        public final AwsCloudFrontDistributionOriginCustomOriginConfig.Builder getCustomOriginConfig() {
            return this.customOriginConfig != null ? this.customOriginConfig.toBuilder() : null;
        }

        public final void setCustomOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig.BuilderImpl customOriginConfig) {
            this.customOriginConfig = customOriginConfig != null ? customOriginConfig.build() : null;
        }

        @Override
        public final Builder customOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig) {
            this.customOriginConfig = customOriginConfig;
            return this;
        }

        public AwsCloudFrontDistributionOriginItem build() {
            return new AwsCloudFrontDistributionOriginItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionOriginItem> {
        public Builder domainName(String var1);

        public Builder id(String var1);

        public Builder originPath(String var1);

        public Builder s3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig var1);

        default public Builder s3OriginConfig(Consumer<AwsCloudFrontDistributionOriginS3OriginConfig.Builder> s3OriginConfig) {
            return this.s3OriginConfig((AwsCloudFrontDistributionOriginS3OriginConfig)((AwsCloudFrontDistributionOriginS3OriginConfig.Builder)AwsCloudFrontDistributionOriginS3OriginConfig.builder().applyMutation(s3OriginConfig)).build());
        }

        public Builder customOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig var1);

        default public Builder customOriginConfig(Consumer<AwsCloudFrontDistributionOriginCustomOriginConfig.Builder> customOriginConfig) {
            return this.customOriginConfig((AwsCloudFrontDistributionOriginCustomOriginConfig)((AwsCloudFrontDistributionOriginCustomOriginConfig.Builder)AwsCloudFrontDistributionOriginCustomOriginConfig.builder().applyMutation(customOriginConfig)).build());
        }
    }
}

