/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsSageMakerNotebookInstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsSageMakerNotebookInstanceDetails> {
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorTypes").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::acceleratorTypes)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::acceleratorTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalCodeRepositories").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::additionalCodeRepositories)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::additionalCodeRepositories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultCodeRepository").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::defaultCodeRepository)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::defaultCodeRepository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build()}).build();
    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectInternetAccess").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::directInternetAccess)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::directInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::failureReason)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails> INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMetadataServiceConfiguration").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::instanceMetadataServiceConfiguration)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::instanceMetadataServiceConfiguration)).constructor(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataServiceConfiguration").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::instanceType)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::kmsKeyId)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::networkInterfaceId)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceArn").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceArn)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::notebookInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceArn").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceLifecycleConfigName").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceLifecycleConfigName)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::notebookInstanceLifecycleConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigName").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceName").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceName)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::notebookInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build()}).build();
    private static final SdkField<String> NOTEBOOK_INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceStatus").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::notebookInstanceStatus)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::notebookInstanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceStatus").build()}).build();
    private static final SdkField<String> PLATFORM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformIdentifier").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::platformIdentifier)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::platformIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformIdentifier").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::roleArn)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootAccess").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::rootAccess)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::rootAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::securityGroups)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::subnetId)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::url)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeInGB").getter(AwsSageMakerNotebookInstanceDetails.getter(AwsSageMakerNotebookInstanceDetails::volumeSizeInGB)).setter(AwsSageMakerNotebookInstanceDetails.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_TYPES_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, DEFAULT_CODE_REPOSITORY_FIELD, DIRECT_INTERNET_ACCESS_FIELD, FAILURE_REASON_FIELD, INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD, INSTANCE_TYPE_FIELD, KMS_KEY_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, NOTEBOOK_INSTANCE_ARN_FIELD, NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD, NOTEBOOK_INSTANCE_NAME_FIELD, NOTEBOOK_INSTANCE_STATUS_FIELD, PLATFORM_IDENTIFIER_FIELD, ROLE_ARN_FIELD, ROOT_ACCESS_FIELD, SECURITY_GROUPS_FIELD, SUBNET_ID_FIELD, URL_FIELD, VOLUME_SIZE_IN_GB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsSageMakerNotebookInstanceDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> acceleratorTypes;
    private final List<String> additionalCodeRepositories;
    private final String defaultCodeRepository;
    private final String directInternetAccess;
    private final String failureReason;
    private final AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration;
    private final String instanceType;
    private final String kmsKeyId;
    private final String networkInterfaceId;
    private final String notebookInstanceArn;
    private final String notebookInstanceLifecycleConfigName;
    private final String notebookInstanceName;
    private final String notebookInstanceStatus;
    private final String platformIdentifier;
    private final String roleArn;
    private final String rootAccess;
    private final List<String> securityGroups;
    private final String subnetId;
    private final String url;
    private final Integer volumeSizeInGB;

    private AwsSageMakerNotebookInstanceDetails(BuilderImpl builder) {
        this.acceleratorTypes = builder.acceleratorTypes;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.directInternetAccess = builder.directInternetAccess;
        this.failureReason = builder.failureReason;
        this.instanceMetadataServiceConfiguration = builder.instanceMetadataServiceConfiguration;
        this.instanceType = builder.instanceType;
        this.kmsKeyId = builder.kmsKeyId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.platformIdentifier = builder.platformIdentifier;
        this.roleArn = builder.roleArn;
        this.rootAccess = builder.rootAccess;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.url = builder.url;
        this.volumeSizeInGB = builder.volumeSizeInGB;
    }

    public final boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorTypes() {
        return this.acceleratorTypes;
    }

    public final boolean hasAdditionalCodeRepositories() {
        return this.additionalCodeRepositories != null && !(this.additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    public final List<String> additionalCodeRepositories() {
        return this.additionalCodeRepositories;
    }

    public final String defaultCodeRepository() {
        return this.defaultCodeRepository;
    }

    public final String directInternetAccess() {
        return this.directInternetAccess;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration() {
        return this.instanceMetadataServiceConfiguration;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String notebookInstanceArn() {
        return this.notebookInstanceArn;
    }

    public final String notebookInstanceLifecycleConfigName() {
        return this.notebookInstanceLifecycleConfigName;
    }

    public final String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public final String notebookInstanceStatus() {
        return this.notebookInstanceStatus;
    }

    public final String platformIdentifier() {
        return this.platformIdentifier;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String rootAccess() {
        return this.rootAccess;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String url() {
        return this.url;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalCodeRepositories() ? this.additionalCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.directInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSageMakerNotebookInstanceDetails)) {
            return false;
        }
        AwsSageMakerNotebookInstanceDetails other = (AwsSageMakerNotebookInstanceDetails)obj;
        return this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypes(), other.acceleratorTypes()) && this.hasAdditionalCodeRepositories() == other.hasAdditionalCodeRepositories() && Objects.equals(this.additionalCodeRepositories(), other.additionalCodeRepositories()) && Objects.equals(this.defaultCodeRepository(), other.defaultCodeRepository()) && Objects.equals(this.directInternetAccess(), other.directInternetAccess()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.instanceMetadataServiceConfiguration(), other.instanceMetadataServiceConfiguration()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.notebookInstanceArn(), other.notebookInstanceArn()) && Objects.equals(this.notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName()) && Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.notebookInstanceStatus(), other.notebookInstanceStatus()) && Objects.equals(this.platformIdentifier(), other.platformIdentifier()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.rootAccess(), other.rootAccess()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB());
    }

    public final String toString() {
        return ToString.builder((String)"AwsSageMakerNotebookInstanceDetails").add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypes() : null).add("AdditionalCodeRepositories", this.hasAdditionalCodeRepositories() ? this.additionalCodeRepositories() : null).add("DefaultCodeRepository", (Object)this.defaultCodeRepository()).add("DirectInternetAccess", (Object)this.directInternetAccess()).add("FailureReason", (Object)this.failureReason()).add("InstanceMetadataServiceConfiguration", (Object)this.instanceMetadataServiceConfiguration()).add("InstanceType", (Object)this.instanceType()).add("KmsKeyId", (Object)this.kmsKeyId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("NotebookInstanceArn", (Object)this.notebookInstanceArn()).add("NotebookInstanceLifecycleConfigName", (Object)this.notebookInstanceLifecycleConfigName()).add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("NotebookInstanceStatus", (Object)this.notebookInstanceStatus()).add("PlatformIdentifier", (Object)this.platformIdentifier()).add("RoleArn", (Object)this.roleArn()).add("RootAccess", (Object)this.rootAccess()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SubnetId", (Object)this.subnetId()).add("Url", (Object)this.url()).add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypes()));
            }
            case "AdditionalCodeRepositories": {
                return Optional.ofNullable(clazz.cast(this.additionalCodeRepositories()));
            }
            case "DefaultCodeRepository": {
                return Optional.ofNullable(clazz.cast(this.defaultCodeRepository()));
            }
            case "DirectInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.directInternetAccess()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "InstanceMetadataServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataServiceConfiguration()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "NotebookInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceArn()));
            }
            case "NotebookInstanceLifecycleConfigName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceLifecycleConfigName()));
            }
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "NotebookInstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceStatus()));
            }
            case "PlatformIdentifier": {
                return Optional.ofNullable(clazz.cast(this.platformIdentifier()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "RootAccess": {
                return Optional.ofNullable(clazz.cast(this.rootAccess()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AcceleratorTypes", ACCELERATOR_TYPES_FIELD);
        map.put("AdditionalCodeRepositories", ADDITIONAL_CODE_REPOSITORIES_FIELD);
        map.put("DefaultCodeRepository", DEFAULT_CODE_REPOSITORY_FIELD);
        map.put("DirectInternetAccess", DIRECT_INTERNET_ACCESS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("InstanceMetadataServiceConfiguration", INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("NotebookInstanceArn", NOTEBOOK_INSTANCE_ARN_FIELD);
        map.put("NotebookInstanceLifecycleConfigName", NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD);
        map.put("NotebookInstanceName", NOTEBOOK_INSTANCE_NAME_FIELD);
        map.put("NotebookInstanceStatus", NOTEBOOK_INSTANCE_STATUS_FIELD);
        map.put("PlatformIdentifier", PLATFORM_IDENTIFIER_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("RootAccess", ROOT_ACCESS_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Url", URL_FIELD);
        map.put("VolumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsSageMakerNotebookInstanceDetails, T> g) {
        return obj -> g.apply((AwsSageMakerNotebookInstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();
        private String defaultCodeRepository;
        private String directInternetAccess;
        private String failureReason;
        private AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration;
        private String instanceType;
        private String kmsKeyId;
        private String networkInterfaceId;
        private String notebookInstanceArn;
        private String notebookInstanceLifecycleConfigName;
        private String notebookInstanceName;
        private String notebookInstanceStatus;
        private String platformIdentifier;
        private String roleArn;
        private String rootAccess;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String subnetId;
        private String url;
        private Integer volumeSizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSageMakerNotebookInstanceDetails model) {
            this.acceleratorTypes(model.acceleratorTypes);
            this.additionalCodeRepositories(model.additionalCodeRepositories);
            this.defaultCodeRepository(model.defaultCodeRepository);
            this.directInternetAccess(model.directInternetAccess);
            this.failureReason(model.failureReason);
            this.instanceMetadataServiceConfiguration(model.instanceMetadataServiceConfiguration);
            this.instanceType(model.instanceType);
            this.kmsKeyId(model.kmsKeyId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.notebookInstanceArn(model.notebookInstanceArn);
            this.notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            this.notebookInstanceName(model.notebookInstanceName);
            this.notebookInstanceStatus(model.notebookInstanceStatus);
            this.platformIdentifier(model.platformIdentifier);
            this.roleArn(model.roleArn);
            this.rootAccess(model.rootAccess);
            this.securityGroups(model.securityGroups);
            this.subnetId(model.subnetId);
            this.url(model.url);
            this.volumeSizeInGB(model.volumeSizeInGB);
        }

        public final Collection<String> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(String ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            if (this.additionalCodeRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalCodeRepositories;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = NonEmptyStringListCopier.copy(additionalCodeRepositories);
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = NonEmptyStringListCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String ... additionalCodeRepositories) {
            this.additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final String getDefaultCodeRepository() {
            return this.defaultCodeRepository;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final String getDirectInternetAccess() {
            return this.directInternetAccess;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        @Override
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder getInstanceMetadataServiceConfiguration() {
            return this.instanceMetadataServiceConfiguration != null ? this.instanceMetadataServiceConfiguration.toBuilder() : null;
        }

        public final void setInstanceMetadataServiceConfiguration(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.BuilderImpl instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration.build() : null;
        }

        @Override
        public final Builder instanceMetadataServiceConfiguration(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getNotebookInstanceArn() {
            return this.notebookInstanceArn;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return this.notebookInstanceLifecycleConfigName;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final String getNotebookInstanceStatus() {
            return this.notebookInstanceStatus;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        public final String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        public final void setPlatformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
        }

        @Override
        public final Builder platformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRootAccess() {
            return this.rootAccess;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = NonEmptyStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public AwsSageMakerNotebookInstanceDetails build() {
            return new AwsSageMakerNotebookInstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsSageMakerNotebookInstanceDetails> {
        public Builder acceleratorTypes(Collection<String> var1);

        public Builder acceleratorTypes(String ... var1);

        public Builder additionalCodeRepositories(Collection<String> var1);

        public Builder additionalCodeRepositories(String ... var1);

        public Builder defaultCodeRepository(String var1);

        public Builder directInternetAccess(String var1);

        public Builder failureReason(String var1);

        public Builder instanceMetadataServiceConfiguration(AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails var1);

        default public Builder instanceMetadataServiceConfiguration(Consumer<AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder> instanceMetadataServiceConfiguration) {
            return this.instanceMetadataServiceConfiguration((AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails)((AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.Builder)AwsSageMakerNotebookInstanceMetadataServiceConfigurationDetails.builder().applyMutation(instanceMetadataServiceConfiguration)).build());
        }

        public Builder instanceType(String var1);

        public Builder kmsKeyId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder notebookInstanceArn(String var1);

        public Builder notebookInstanceLifecycleConfigName(String var1);

        public Builder notebookInstanceName(String var1);

        public Builder notebookInstanceStatus(String var1);

        public Builder platformIdentifier(String var1);

        public Builder roleArn(String var1);

        public Builder rootAccess(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetId(String var1);

        public Builder url(String var1);

        public Builder volumeSizeInGB(Integer var1);
    }
}

