/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicy;
import software.amazon.awssdk.services.securityhub.model.AwsIamAttachedManagedPolicyListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfile;
import software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsIamPermissionsBoundary;
import software.amazon.awssdk.services.securityhub.model.AwsIamRolePolicy;
import software.amazon.awssdk.services.securityhub.model.AwsIamRolePolicyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsIamRoleDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsIamRoleDetails> {
    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssumeRolePolicyDocument").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::assumeRolePolicyDocument)).setter(AwsIamRoleDetails.setter(Builder::assumeRolePolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build()}).build();
    private static final SdkField<List<AwsIamAttachedManagedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachedManagedPolicies").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::attachedManagedPolicies)).setter(AwsIamRoleDetails.setter(Builder::attachedManagedPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsIamAttachedManagedPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreateDate").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::createDate)).setter(AwsIamRoleDetails.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<List<AwsIamInstanceProfile>> INSTANCE_PROFILE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceProfileList").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::instanceProfileList)).setter(AwsIamRoleDetails.setter(Builder::instanceProfileList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsIamInstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsIamPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionsBoundary").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::permissionsBoundary)).setter(AwsIamRoleDetails.setter(Builder::permissionsBoundary)).constructor(AwsIamPermissionsBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build()}).build();
    private static final SdkField<String> ROLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleId").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::roleId)).setter(AwsIamRoleDetails.setter(Builder::roleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::roleName)).setter(AwsIamRoleDetails.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()}).build();
    private static final SdkField<List<AwsIamRolePolicy>> ROLE_POLICY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RolePolicyList").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::rolePolicyList)).setter(AwsIamRoleDetails.setter(Builder::rolePolicyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolePolicyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsIamRolePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSessionDuration").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::maxSessionDuration)).setter(AwsIamRoleDetails.setter(Builder::maxSessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(AwsIamRoleDetails.getter(AwsIamRoleDetails::path)).setter(AwsIamRoleDetails.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSUME_ROLE_POLICY_DOCUMENT_FIELD, ATTACHED_MANAGED_POLICIES_FIELD, CREATE_DATE_FIELD, INSTANCE_PROFILE_LIST_FIELD, PERMISSIONS_BOUNDARY_FIELD, ROLE_ID_FIELD, ROLE_NAME_FIELD, ROLE_POLICY_LIST_FIELD, MAX_SESSION_DURATION_FIELD, PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsIamRoleDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assumeRolePolicyDocument;
    private final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies;
    private final String createDate;
    private final List<AwsIamInstanceProfile> instanceProfileList;
    private final AwsIamPermissionsBoundary permissionsBoundary;
    private final String roleId;
    private final String roleName;
    private final List<AwsIamRolePolicy> rolePolicyList;
    private final Integer maxSessionDuration;
    private final String path;

    private AwsIamRoleDetails(BuilderImpl builder) {
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.createDate = builder.createDate;
        this.instanceProfileList = builder.instanceProfileList;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.roleId = builder.roleId;
        this.roleName = builder.roleName;
        this.rolePolicyList = builder.rolePolicyList;
        this.maxSessionDuration = builder.maxSessionDuration;
        this.path = builder.path;
    }

    public final String assumeRolePolicyDocument() {
        return this.assumeRolePolicyDocument;
    }

    public final boolean hasAttachedManagedPolicies() {
        return this.attachedManagedPolicies != null && !(this.attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    public final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public final String createDate() {
        return this.createDate;
    }

    public final boolean hasInstanceProfileList() {
        return this.instanceProfileList != null && !(this.instanceProfileList instanceof SdkAutoConstructList);
    }

    public final List<AwsIamInstanceProfile> instanceProfileList() {
        return this.instanceProfileList;
    }

    public final AwsIamPermissionsBoundary permissionsBoundary() {
        return this.permissionsBoundary;
    }

    public final String roleId() {
        return this.roleId;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final boolean hasRolePolicyList() {
        return this.rolePolicyList != null && !(this.rolePolicyList instanceof SdkAutoConstructList);
    }

    public final List<AwsIamRolePolicy> rolePolicyList() {
        return this.rolePolicyList;
    }

    public final Integer maxSessionDuration() {
        return this.maxSessionDuration;
    }

    public final String path() {
        return this.path;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachedManagedPolicies() ? this.attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceProfileList() ? this.instanceProfileList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRolePolicyList() ? this.rolePolicyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamRoleDetails)) {
            return false;
        }
        AwsIamRoleDetails other = (AwsIamRoleDetails)obj;
        return Objects.equals(this.assumeRolePolicyDocument(), other.assumeRolePolicyDocument()) && this.hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies() && Objects.equals(this.attachedManagedPolicies(), other.attachedManagedPolicies()) && Objects.equals(this.createDate(), other.createDate()) && this.hasInstanceProfileList() == other.hasInstanceProfileList() && Objects.equals(this.instanceProfileList(), other.instanceProfileList()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary()) && Objects.equals(this.roleId(), other.roleId()) && Objects.equals(this.roleName(), other.roleName()) && this.hasRolePolicyList() == other.hasRolePolicyList() && Objects.equals(this.rolePolicyList(), other.rolePolicyList()) && Objects.equals(this.maxSessionDuration(), other.maxSessionDuration()) && Objects.equals(this.path(), other.path());
    }

    public final String toString() {
        return ToString.builder((String)"AwsIamRoleDetails").add("AssumeRolePolicyDocument", (Object)this.assumeRolePolicyDocument()).add("AttachedManagedPolicies", this.hasAttachedManagedPolicies() ? this.attachedManagedPolicies() : null).add("CreateDate", (Object)this.createDate()).add("InstanceProfileList", this.hasInstanceProfileList() ? this.instanceProfileList() : null).add("PermissionsBoundary", (Object)this.permissionsBoundary()).add("RoleId", (Object)this.roleId()).add("RoleName", (Object)this.roleName()).add("RolePolicyList", this.hasRolePolicyList() ? this.rolePolicyList() : null).add("MaxSessionDuration", (Object)this.maxSessionDuration()).add("Path", (Object)this.path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssumeRolePolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.assumeRolePolicyDocument()));
            }
            case "AttachedManagedPolicies": {
                return Optional.ofNullable(clazz.cast(this.attachedManagedPolicies()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "InstanceProfileList": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileList()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
            case "RoleId": {
                return Optional.ofNullable(clazz.cast(this.roleId()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "RolePolicyList": {
                return Optional.ofNullable(clazz.cast(this.rolePolicyList()));
            }
            case "MaxSessionDuration": {
                return Optional.ofNullable(clazz.cast(this.maxSessionDuration()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssumeRolePolicyDocument", ASSUME_ROLE_POLICY_DOCUMENT_FIELD);
        map.put("AttachedManagedPolicies", ATTACHED_MANAGED_POLICIES_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("InstanceProfileList", INSTANCE_PROFILE_LIST_FIELD);
        map.put("PermissionsBoundary", PERMISSIONS_BOUNDARY_FIELD);
        map.put("RoleId", ROLE_ID_FIELD);
        map.put("RoleName", ROLE_NAME_FIELD);
        map.put("RolePolicyList", ROLE_POLICY_LIST_FIELD);
        map.put("MaxSessionDuration", MAX_SESSION_DURATION_FIELD);
        map.put("Path", PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsIamRoleDetails, T> g) {
        return obj -> g.apply((AwsIamRoleDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assumeRolePolicyDocument;
        private List<AwsIamAttachedManagedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();
        private String createDate;
        private List<AwsIamInstanceProfile> instanceProfileList = DefaultSdkAutoConstructList.getInstance();
        private AwsIamPermissionsBoundary permissionsBoundary;
        private String roleId;
        private String roleName;
        private List<AwsIamRolePolicy> rolePolicyList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxSessionDuration;
        private String path;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamRoleDetails model) {
            this.assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            this.attachedManagedPolicies(model.attachedManagedPolicies);
            this.createDate(model.createDate);
            this.instanceProfileList(model.instanceProfileList);
            this.permissionsBoundary(model.permissionsBoundary);
            this.roleId(model.roleId);
            this.roleName(model.roleName);
            this.rolePolicyList(model.rolePolicyList);
            this.maxSessionDuration(model.maxSessionDuration);
            this.path(model.path);
        }

        public final String getAssumeRolePolicyDocument() {
            return this.assumeRolePolicyDocument;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final List<AwsIamAttachedManagedPolicy.Builder> getAttachedManagedPolicies() {
            List<AwsIamAttachedManagedPolicy.Builder> result = AwsIamAttachedManagedPolicyListCopier.copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copyFromBuilder(attachedManagedPolicies);
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder> ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Stream.of(attachedManagedPolicies).map(c -> (AwsIamAttachedManagedPolicy)((AwsIamAttachedManagedPolicy.Builder)AwsIamAttachedManagedPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final List<AwsIamInstanceProfile.Builder> getInstanceProfileList() {
            List<AwsIamInstanceProfile.Builder> result = AwsIamInstanceProfileListCopier.copyToBuilder(this.instanceProfileList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceProfileList(Collection<AwsIamInstanceProfile.BuilderImpl> instanceProfileList) {
            this.instanceProfileList = AwsIamInstanceProfileListCopier.copyFromBuilder(instanceProfileList);
        }

        @Override
        public final Builder instanceProfileList(Collection<AwsIamInstanceProfile> instanceProfileList) {
            this.instanceProfileList = AwsIamInstanceProfileListCopier.copy(instanceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(AwsIamInstanceProfile ... instanceProfileList) {
            this.instanceProfileList(Arrays.asList(instanceProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(Consumer<AwsIamInstanceProfile.Builder> ... instanceProfileList) {
            this.instanceProfileList(Stream.of(instanceProfileList).map(c -> (AwsIamInstanceProfile)((AwsIamInstanceProfile.Builder)AwsIamInstanceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsIamPermissionsBoundary.Builder getPermissionsBoundary() {
            return this.permissionsBoundary != null ? this.permissionsBoundary.toBuilder() : null;
        }

        public final void setPermissionsBoundary(AwsIamPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        @Override
        public final Builder permissionsBoundary(AwsIamPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final String getRoleId() {
            return this.roleId;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final List<AwsIamRolePolicy.Builder> getRolePolicyList() {
            List<AwsIamRolePolicy.Builder> result = AwsIamRolePolicyListCopier.copyToBuilder(this.rolePolicyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRolePolicyList(Collection<AwsIamRolePolicy.BuilderImpl> rolePolicyList) {
            this.rolePolicyList = AwsIamRolePolicyListCopier.copyFromBuilder(rolePolicyList);
        }

        @Override
        public final Builder rolePolicyList(Collection<AwsIamRolePolicy> rolePolicyList) {
            this.rolePolicyList = AwsIamRolePolicyListCopier.copy(rolePolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(AwsIamRolePolicy ... rolePolicyList) {
            this.rolePolicyList(Arrays.asList(rolePolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(Consumer<AwsIamRolePolicy.Builder> ... rolePolicyList) {
            this.rolePolicyList(Stream.of(rolePolicyList).map(c -> (AwsIamRolePolicy)((AwsIamRolePolicy.Builder)AwsIamRolePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxSessionDuration() {
            return this.maxSessionDuration;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public AwsIamRoleDetails build() {
            return new AwsIamRoleDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsIamRoleDetails> {
        public Builder assumeRolePolicyDocument(String var1);

        public Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> var1);

        public Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy ... var1);

        public Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder> ... var1);

        public Builder createDate(String var1);

        public Builder instanceProfileList(Collection<AwsIamInstanceProfile> var1);

        public Builder instanceProfileList(AwsIamInstanceProfile ... var1);

        public Builder instanceProfileList(Consumer<AwsIamInstanceProfile.Builder> ... var1);

        public Builder permissionsBoundary(AwsIamPermissionsBoundary var1);

        default public Builder permissionsBoundary(Consumer<AwsIamPermissionsBoundary.Builder> permissionsBoundary) {
            return this.permissionsBoundary((AwsIamPermissionsBoundary)((AwsIamPermissionsBoundary.Builder)AwsIamPermissionsBoundary.builder().applyMutation(permissionsBoundary)).build());
        }

        public Builder roleId(String var1);

        public Builder roleName(String var1);

        public Builder rolePolicyList(Collection<AwsIamRolePolicy> var1);

        public Builder rolePolicyList(AwsIamRolePolicy ... var1);

        public Builder rolePolicyList(Consumer<AwsIamRolePolicy.Builder> ... var1);

        public Builder maxSessionDuration(Integer var1);

        public Builder path(String var1);
    }
}

