/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscription;

public class GetEnabledStandardsIterable
implements SdkIterable<GetEnabledStandardsResponse> {
    private final SecurityHubClient client;
    private final GetEnabledStandardsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetEnabledStandardsIterable(SecurityHubClient client, GetEnabledStandardsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetEnabledStandardsResponseFetcher();
    }

    public Iterator<GetEnabledStandardsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StandardsSubscription> standardsSubscriptions() {
        Function<GetEnabledStandardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.standardsSubscriptions() != null) {
                return response.standardsSubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetEnabledStandardsResponseFetcher
    implements SyncPageFetcher<GetEnabledStandardsResponse> {
        private GetEnabledStandardsResponseFetcher() {
        }

        public boolean hasNextPage(GetEnabledStandardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetEnabledStandardsResponse nextPage(GetEnabledStandardsResponse previousPage) {
            if (previousPage == null) {
                return GetEnabledStandardsIterable.this.client.getEnabledStandards(GetEnabledStandardsIterable.this.firstRequest);
            }
            return GetEnabledStandardsIterable.this.client.getEnabledStandards((GetEnabledStandardsRequest)((Object)GetEnabledStandardsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

