/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ActionTarget;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse;

public class DescribeActionTargetsPublisher
implements SdkPublisher<DescribeActionTargetsResponse> {
    private final SecurityHubAsyncClient client;
    private final DescribeActionTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeActionTargetsPublisher(SecurityHubAsyncClient client, DescribeActionTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeActionTargetsPublisher(SecurityHubAsyncClient client, DescribeActionTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeActionTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeActionTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActionTarget> actionTargets() {
        Function<DescribeActionTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionTargets() != null) {
                return response.actionTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeActionTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeActionTargetsResponseFetcher
    implements AsyncPageFetcher<DescribeActionTargetsResponse> {
        private DescribeActionTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeActionTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeActionTargetsResponse> nextPage(DescribeActionTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeActionTargetsPublisher.this.client.describeActionTargets(DescribeActionTargetsPublisher.this.firstRequest);
            }
            return DescribeActionTargetsPublisher.this.client.describeActionTargets((DescribeActionTargetsRequest)((Object)DescribeActionTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

