/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringListConfigurationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringListConfigurationOptions> {
    private static final SdkField<List<String>> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultValue").getter(StringListConfigurationOptions.getter(StringListConfigurationOptions::defaultValue)).setter(StringListConfigurationOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RE2_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Re2Expression").getter(StringListConfigurationOptions.getter(StringListConfigurationOptions::re2Expression)).setter(StringListConfigurationOptions.setter(Builder::re2Expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Re2Expression").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(StringListConfigurationOptions.getter(StringListConfigurationOptions::maxItems)).setter(StringListConfigurationOptions.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<String> EXPRESSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpressionDescription").getter(StringListConfigurationOptions.getter(StringListConfigurationOptions::expressionDescription)).setter(StringListConfigurationOptions.setter(Builder::expressionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, RE2_EXPRESSION_FIELD, MAX_ITEMS_FIELD, EXPRESSION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StringListConfigurationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> defaultValue;
    private final String re2Expression;
    private final Integer maxItems;
    private final String expressionDescription;

    private StringListConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.re2Expression = builder.re2Expression;
        this.maxItems = builder.maxItems;
        this.expressionDescription = builder.expressionDescription;
    }

    public final boolean hasDefaultValue() {
        return this.defaultValue != null && !(this.defaultValue instanceof SdkAutoConstructList);
    }

    public final List<String> defaultValue() {
        return this.defaultValue;
    }

    public final String re2Expression() {
        return this.re2Expression;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String expressionDescription() {
        return this.expressionDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultValue() ? this.defaultValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.re2Expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringListConfigurationOptions)) {
            return false;
        }
        StringListConfigurationOptions other = (StringListConfigurationOptions)obj;
        return this.hasDefaultValue() == other.hasDefaultValue() && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.re2Expression(), other.re2Expression()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.expressionDescription(), other.expressionDescription());
    }

    public final String toString() {
        return ToString.builder((String)"StringListConfigurationOptions").add("DefaultValue", this.hasDefaultValue() ? this.defaultValue() : null).add("Re2Expression", (Object)this.re2Expression()).add("MaxItems", (Object)this.maxItems()).add("ExpressionDescription", (Object)this.expressionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Re2Expression": {
                return Optional.ofNullable(clazz.cast(this.re2Expression()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "ExpressionDescription": {
                return Optional.ofNullable(clazz.cast(this.expressionDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Re2Expression", RE2_EXPRESSION_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("ExpressionDescription", EXPRESSION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringListConfigurationOptions, T> g) {
        return obj -> g.apply((StringListConfigurationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> defaultValue = DefaultSdkAutoConstructList.getInstance();
        private String re2Expression;
        private Integer maxItems;
        private String expressionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(StringListConfigurationOptions model) {
            this.defaultValue(model.defaultValue);
            this.re2Expression(model.re2Expression);
            this.maxItems(model.maxItems);
            this.expressionDescription(model.expressionDescription);
        }

        public final Collection<String> getDefaultValue() {
            if (this.defaultValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultValue;
        }

        public final void setDefaultValue(Collection<String> defaultValue) {
            this.defaultValue = StringListCopier.copy(defaultValue);
        }

        @Override
        public final Builder defaultValue(Collection<String> defaultValue) {
            this.defaultValue = StringListCopier.copy(defaultValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValue(String ... defaultValue) {
            this.defaultValue(Arrays.asList(defaultValue));
            return this;
        }

        public final String getRe2Expression() {
            return this.re2Expression;
        }

        public final void setRe2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
        }

        @Override
        public final Builder re2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getExpressionDescription() {
            return this.expressionDescription;
        }

        public final void setExpressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
        }

        @Override
        public final Builder expressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
            return this;
        }

        public StringListConfigurationOptions build() {
            return new StringListConfigurationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringListConfigurationOptions> {
        public Builder defaultValue(Collection<String> var1);

        public Builder defaultValue(String ... var1);

        public Builder re2Expression(String var1);

        public Builder maxItems(Integer var1);

        public Builder expressionDescription(String var1);
    }
}

