/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.CodeVulnerabilitiesFilePath;
import software.amazon.awssdk.services.securityhub.model.TypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VulnerabilityCodeVulnerabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VulnerabilityCodeVulnerabilities> {
    private static final SdkField<List<String>> CWES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cwes").getter(VulnerabilityCodeVulnerabilities.getter(VulnerabilityCodeVulnerabilities::cwes)).setter(VulnerabilityCodeVulnerabilities.setter(Builder::cwes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cwes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CodeVulnerabilitiesFilePath> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilePath").getter(VulnerabilityCodeVulnerabilities.getter(VulnerabilityCodeVulnerabilities::filePath)).setter(VulnerabilityCodeVulnerabilities.setter(Builder::filePath)).constructor(CodeVulnerabilitiesFilePath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(VulnerabilityCodeVulnerabilities.getter(VulnerabilityCodeVulnerabilities::sourceArn)).setter(VulnerabilityCodeVulnerabilities.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CWES_FIELD, FILE_PATH_FIELD, SOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VulnerabilityCodeVulnerabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> cwes;
    private final CodeVulnerabilitiesFilePath filePath;
    private final String sourceArn;

    private VulnerabilityCodeVulnerabilities(BuilderImpl builder) {
        this.cwes = builder.cwes;
        this.filePath = builder.filePath;
        this.sourceArn = builder.sourceArn;
    }

    public final boolean hasCwes() {
        return this.cwes != null && !(this.cwes instanceof SdkAutoConstructList);
    }

    public final List<String> cwes() {
        return this.cwes;
    }

    public final CodeVulnerabilitiesFilePath filePath() {
        return this.filePath;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCwes() ? this.cwes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VulnerabilityCodeVulnerabilities)) {
            return false;
        }
        VulnerabilityCodeVulnerabilities other = (VulnerabilityCodeVulnerabilities)obj;
        return this.hasCwes() == other.hasCwes() && Objects.equals(this.cwes(), other.cwes()) && Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.sourceArn(), other.sourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"VulnerabilityCodeVulnerabilities").add("Cwes", this.hasCwes() ? this.cwes() : null).add("FilePath", (Object)this.filePath()).add("SourceArn", (Object)this.sourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cwes": {
                return Optional.ofNullable(clazz.cast(this.cwes()));
            }
            case "FilePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Cwes", CWES_FIELD);
        map.put("FilePath", FILE_PATH_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VulnerabilityCodeVulnerabilities, T> g) {
        return obj -> g.apply((VulnerabilityCodeVulnerabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> cwes = DefaultSdkAutoConstructList.getInstance();
        private CodeVulnerabilitiesFilePath filePath;
        private String sourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VulnerabilityCodeVulnerabilities model) {
            this.cwes(model.cwes);
            this.filePath(model.filePath);
            this.sourceArn(model.sourceArn);
        }

        public final Collection<String> getCwes() {
            if (this.cwes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cwes;
        }

        public final void setCwes(Collection<String> cwes) {
            this.cwes = TypeListCopier.copy(cwes);
        }

        @Override
        public final Builder cwes(Collection<String> cwes) {
            this.cwes = TypeListCopier.copy(cwes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cwes(String ... cwes) {
            this.cwes(Arrays.asList(cwes));
            return this;
        }

        public final CodeVulnerabilitiesFilePath.Builder getFilePath() {
            return this.filePath != null ? this.filePath.toBuilder() : null;
        }

        public final void setFilePath(CodeVulnerabilitiesFilePath.BuilderImpl filePath) {
            this.filePath = filePath != null ? filePath.build() : null;
        }

        @Override
        public final Builder filePath(CodeVulnerabilitiesFilePath filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public VulnerabilityCodeVulnerabilities build() {
            return new VulnerabilityCodeVulnerabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VulnerabilityCodeVulnerabilities> {
        public Builder cwes(Collection<String> var1);

        public Builder cwes(String ... var1);

        public Builder filePath(CodeVulnerabilitiesFilePath var1);

        default public Builder filePath(Consumer<CodeVulnerabilitiesFilePath.Builder> filePath) {
            return this.filePath((CodeVulnerabilitiesFilePath)((CodeVulnerabilitiesFilePath.Builder)CodeVulnerabilitiesFilePath.builder().applyMutation(filePath)).build());
        }

        public Builder sourceArn(String var1);
    }
}

