/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Threat;

final class ThreatListCopier {
    ThreatListCopier() {
    }

    static List<Threat> copy(Collection<? extends Threat> threatListParam) {
        Object list;
        if (threatListParam == null || threatListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(threatListParam.size());
            threatListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Threat> copyFromBuilder(Collection<? extends Threat.Builder> threatListParam) {
        Object list;
        if (threatListParam == null || threatListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(threatListParam.size());
            threatListParam.forEach(entry -> {
                Threat member = entry == null ? null : (Threat)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Threat.Builder> copyToBuilder(Collection<? extends Threat> threatListParam) {
        Object list;
        if (threatListParam == null || threatListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList(threatListParam.size());
            threatListParam.forEach(entry -> {
                Threat.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

