/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesHeaderDetails;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupSourceStatefulRulesDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupSourceStatefulRulesDetails> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(RuleGroupSourceStatefulRulesDetails.getter(RuleGroupSourceStatefulRulesDetails::action)).setter(RuleGroupSourceStatefulRulesDetails.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<RuleGroupSourceStatefulRulesHeaderDetails> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Header").getter(RuleGroupSourceStatefulRulesDetails.getter(RuleGroupSourceStatefulRulesDetails::header)).setter(RuleGroupSourceStatefulRulesDetails.setter(Builder::header)).constructor(RuleGroupSourceStatefulRulesHeaderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()}).build();
    private static final SdkField<List<RuleGroupSourceStatefulRulesOptionsDetails>> RULE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleOptions").getter(RuleGroupSourceStatefulRulesDetails.getter(RuleGroupSourceStatefulRulesDetails::ruleOptions)).setter(RuleGroupSourceStatefulRulesDetails.setter(Builder::ruleOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupSourceStatefulRulesOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, HEADER_FIELD, RULE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleGroupSourceStatefulRulesDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final RuleGroupSourceStatefulRulesHeaderDetails header;
    private final List<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions;

    private RuleGroupSourceStatefulRulesDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.header = builder.header;
        this.ruleOptions = builder.ruleOptions;
    }

    public final String action() {
        return this.action;
    }

    public final RuleGroupSourceStatefulRulesHeaderDetails header() {
        return this.header;
    }

    public final boolean hasRuleOptions() {
        return this.ruleOptions != null && !(this.ruleOptions instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions() {
        return this.ruleOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.header());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleOptions() ? this.ruleOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatefulRulesDetails)) {
            return false;
        }
        RuleGroupSourceStatefulRulesDetails other = (RuleGroupSourceStatefulRulesDetails)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.header(), other.header()) && this.hasRuleOptions() == other.hasRuleOptions() && Objects.equals(this.ruleOptions(), other.ruleOptions());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupSourceStatefulRulesDetails").add("Action", (Object)this.action()).add("Header", (Object)this.header()).add("RuleOptions", this.hasRuleOptions() ? this.ruleOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
            case "RuleOptions": {
                return Optional.ofNullable(clazz.cast(this.ruleOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("Header", HEADER_FIELD);
        map.put("RuleOptions", RULE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatefulRulesDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceStatefulRulesDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private RuleGroupSourceStatefulRulesHeaderDetails header;
        private List<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatefulRulesDetails model) {
            this.action(model.action);
            this.header(model.header);
            this.ruleOptions(model.ruleOptions);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final RuleGroupSourceStatefulRulesHeaderDetails.Builder getHeader() {
            return this.header != null ? this.header.toBuilder() : null;
        }

        public final void setHeader(RuleGroupSourceStatefulRulesHeaderDetails.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        public final Builder header(RuleGroupSourceStatefulRulesHeaderDetails header) {
            this.header = header;
            return this;
        }

        public final List<RuleGroupSourceStatefulRulesOptionsDetails.Builder> getRuleOptions() {
            List<RuleGroupSourceStatefulRulesOptionsDetails.Builder> result = RuleGroupSourceStatefulRulesOptionsListCopier.copyToBuilder(this.ruleOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleOptions(Collection<RuleGroupSourceStatefulRulesOptionsDetails.BuilderImpl> ruleOptions) {
            this.ruleOptions = RuleGroupSourceStatefulRulesOptionsListCopier.copyFromBuilder(ruleOptions);
        }

        @Override
        public final Builder ruleOptions(Collection<RuleGroupSourceStatefulRulesOptionsDetails> ruleOptions) {
            this.ruleOptions = RuleGroupSourceStatefulRulesOptionsListCopier.copy(ruleOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(RuleGroupSourceStatefulRulesOptionsDetails ... ruleOptions) {
            this.ruleOptions(Arrays.asList(ruleOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleOptions(Consumer<RuleGroupSourceStatefulRulesOptionsDetails.Builder> ... ruleOptions) {
            this.ruleOptions(Stream.of(ruleOptions).map(c -> (RuleGroupSourceStatefulRulesOptionsDetails)((RuleGroupSourceStatefulRulesOptionsDetails.Builder)RuleGroupSourceStatefulRulesOptionsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RuleGroupSourceStatefulRulesDetails build() {
            return new RuleGroupSourceStatefulRulesDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupSourceStatefulRulesDetails> {
        public Builder action(String var1);

        public Builder header(RuleGroupSourceStatefulRulesHeaderDetails var1);

        default public Builder header(Consumer<RuleGroupSourceStatefulRulesHeaderDetails.Builder> header) {
            return this.header((RuleGroupSourceStatefulRulesHeaderDetails)((RuleGroupSourceStatefulRulesHeaderDetails.Builder)RuleGroupSourceStatefulRulesHeaderDetails.builder().applyMutation(header)).build());
        }

        public Builder ruleOptions(Collection<RuleGroupSourceStatefulRulesOptionsDetails> var1);

        public Builder ruleOptions(RuleGroupSourceStatefulRulesOptionsDetails ... var1);

        public Builder ruleOptions(Consumer<RuleGroupSourceStatefulRulesOptionsDetails.Builder> ... var1);
    }
}

