/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord;
import software.amazon.awssdk.services.securityhub.model.FindingHistoryRecordListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingHistoryResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetFindingHistoryResponse> {
    private static final SdkField<List<FindingHistoryRecord>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(GetFindingHistoryResponse.getter(GetFindingHistoryResponse::records)).setter(GetFindingHistoryResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingHistoryRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetFindingHistoryResponse.getter(GetFindingHistoryResponse::nextToken)).setter(GetFindingHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFindingHistoryResponse.memberNameToFieldInitializer();
    private final List<FindingHistoryRecord> records;
    private final String nextToken;

    private GetFindingHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<FindingHistoryRecord> records() {
        return this.records;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingHistoryResponse)) {
            return false;
        }
        GetFindingHistoryResponse other = (GetFindingHistoryResponse)((Object)obj);
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingHistoryResponse").add("Records", this.hasRecords() ? this.records() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Records", RECORDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingHistoryResponse, T> g) {
        return obj -> g.apply((GetFindingHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<FindingHistoryRecord> records = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingHistoryResponse model) {
            super(model);
            this.records(model.records);
            this.nextToken(model.nextToken);
        }

        public final List<FindingHistoryRecord.Builder> getRecords() {
            List<FindingHistoryRecord.Builder> result = FindingHistoryRecordListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<FindingHistoryRecord.BuilderImpl> records) {
            this.records = FindingHistoryRecordListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<FindingHistoryRecord> records) {
            this.records = FindingHistoryRecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(FindingHistoryRecord ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<FindingHistoryRecord.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (FindingHistoryRecord)((FindingHistoryRecord.Builder)FindingHistoryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetFindingHistoryResponse build() {
            return new GetFindingHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingHistoryResponse> {
        public Builder records(Collection<FindingHistoryRecord> var1);

        public Builder records(FindingHistoryRecord ... var1);

        public Builder records(Consumer<FindingHistoryRecord.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

