/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContext;
import software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsIamAccessKeyDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsIamAccessKeyDetails> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::userName)).setter(AwsIamAccessKeyDetails.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::statusAsString)).setter(AwsIamAccessKeyDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::createdAt)).setter(AwsIamAccessKeyDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalId").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::principalId)).setter(AwsIamAccessKeyDetails.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalType").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::principalType)).setter(AwsIamAccessKeyDetails.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()}).build();
    private static final SdkField<String> PRINCIPAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalName").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::principalName)).setter(AwsIamAccessKeyDetails.setter(Builder::principalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalName").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::accountId)).setter(AwsIamAccessKeyDetails.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKeyId").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::accessKeyId)).setter(AwsIamAccessKeyDetails.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()}).build();
    private static final SdkField<AwsIamAccessKeySessionContext> SESSION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SessionContext").getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::sessionContext)).setter(AwsIamAccessKeyDetails.setter(Builder::sessionContext)).constructor(AwsIamAccessKeySessionContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, STATUS_FIELD, CREATED_AT_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_NAME_FIELD, ACCOUNT_ID_FIELD, ACCESS_KEY_ID_FIELD, SESSION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsIamAccessKeyDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String status;
    private final String createdAt;
    private final String principalId;
    private final String principalType;
    private final String principalName;
    private final String accountId;
    private final String accessKeyId;
    private final AwsIamAccessKeySessionContext sessionContext;

    private AwsIamAccessKeyDetails(BuilderImpl builder) {
        this.userName = builder.userName;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.principalName = builder.principalName;
        this.accountId = builder.accountId;
        this.accessKeyId = builder.accessKeyId;
        this.sessionContext = builder.sessionContext;
    }

    @Deprecated
    public final String userName() {
        return this.userName;
    }

    public final AwsIamAccessKeyStatus status() {
        return AwsIamAccessKeyStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String createdAt() {
        return this.createdAt;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final String principalType() {
        return this.principalType;
    }

    public final String principalName() {
        return this.principalName;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final AwsIamAccessKeySessionContext sessionContext() {
        return this.sessionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalType());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamAccessKeyDetails)) {
            return false;
        }
        AwsIamAccessKeyDetails other = (AwsIamAccessKeyDetails)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalType(), other.principalType()) && Objects.equals(this.principalName(), other.principalName()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.sessionContext(), other.sessionContext());
    }

    public final String toString() {
        return ToString.builder((String)"AwsIamAccessKeyDetails").add("UserName", (Object)this.userName()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalType()).add("PrincipalName", (Object)this.principalName()).add("AccountId", (Object)this.accountId()).add("AccessKeyId", (Object)this.accessKeyId()).add("SessionContext", (Object)this.sessionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalType()));
            }
            case "PrincipalName": {
                return Optional.ofNullable(clazz.cast(this.principalName()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "SessionContext": {
                return Optional.ofNullable(clazz.cast(this.sessionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        map.put("PrincipalType", PRINCIPAL_TYPE_FIELD);
        map.put("PrincipalName", PRINCIPAL_NAME_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AccessKeyId", ACCESS_KEY_ID_FIELD);
        map.put("SessionContext", SESSION_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsIamAccessKeyDetails, T> g) {
        return obj -> g.apply((AwsIamAccessKeyDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String status;
        private String createdAt;
        private String principalId;
        private String principalType;
        private String principalName;
        private String accountId;
        private String accessKeyId;
        private AwsIamAccessKeySessionContext sessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamAccessKeyDetails model) {
            this.userName(model.userName);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
            this.principalName(model.principalName);
            this.accountId(model.accountId);
            this.accessKeyId(model.accessKeyId);
            this.sessionContext(model.sessionContext);
        }

        @Deprecated
        public final String getUserName() {
            return this.userName;
        }

        @Deprecated
        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Deprecated
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AwsIamAccessKeyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        public final String getPrincipalName() {
            return this.principalName;
        }

        public final void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        @Override
        public final Builder principalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final AwsIamAccessKeySessionContext.Builder getSessionContext() {
            return this.sessionContext != null ? this.sessionContext.toBuilder() : null;
        }

        public final void setSessionContext(AwsIamAccessKeySessionContext.BuilderImpl sessionContext) {
            this.sessionContext = sessionContext != null ? sessionContext.build() : null;
        }

        @Override
        public final Builder sessionContext(AwsIamAccessKeySessionContext sessionContext) {
            this.sessionContext = sessionContext;
            return this;
        }

        public AwsIamAccessKeyDetails build() {
            return new AwsIamAccessKeyDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsIamAccessKeyDetails> {
        @Deprecated
        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder status(AwsIamAccessKeyStatus var1);

        public Builder createdAt(String var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalName(String var1);

        public Builder accountId(String var1);

        public Builder accessKeyId(String var1);

        public Builder sessionContext(AwsIamAccessKeySessionContext var1);

        default public Builder sessionContext(Consumer<AwsIamAccessKeySessionContext.Builder> sessionContext) {
            return this.sessionContext((AwsIamAccessKeySessionContext)((AwsIamAccessKeySessionContext.Builder)AwsIamAccessKeySessionContext.builder().applyMutation(sessionContext)).build());
        }
    }
}

