/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainVPCOptions;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElasticsearchDomainDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElasticsearchDomainDetails> {
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPolicies").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::accessPolicies)).setter(AwsElasticsearchDomainDetails.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<AwsElasticsearchDomainDomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::domainEndpointOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::domainEndpointOptions)).constructor(AwsElasticsearchDomainDomainEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::domainId)).setter(AwsElasticsearchDomainDetails.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::domainName)).setter(AwsElasticsearchDomainDetails.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::endpoint)).setter(AwsElasticsearchDomainDetails.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Endpoints").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::endpoints)).setter(AwsElasticsearchDomainDetails.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticsearchVersion").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::elasticsearchVersion)).setter(AwsElasticsearchDomainDetails.setter(Builder::elasticsearchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build()}).build();
    private static final SdkField<AwsElasticsearchDomainElasticsearchClusterConfigDetails> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticsearchClusterConfig").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::elasticsearchClusterConfig)).setter(AwsElasticsearchDomainDetails.setter(Builder::elasticsearchClusterConfig)).constructor(AwsElasticsearchDomainElasticsearchClusterConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build()}).build();
    private static final SdkField<AwsElasticsearchDomainEncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::encryptionAtRestOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::encryptionAtRestOptions)).constructor(AwsElasticsearchDomainEncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<AwsElasticsearchDomainLogPublishingOptions> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPublishingOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::logPublishingOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::logPublishingOptions)).constructor(AwsElasticsearchDomainLogPublishingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<AwsElasticsearchDomainNodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::nodeToNodeEncryptionOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::nodeToNodeEncryptionOptions)).constructor(AwsElasticsearchDomainNodeToNodeEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<AwsElasticsearchDomainServiceSoftwareOptions> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceSoftwareOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::serviceSoftwareOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::serviceSoftwareOptions)).constructor(AwsElasticsearchDomainServiceSoftwareOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build()}).build();
    private static final SdkField<AwsElasticsearchDomainVPCOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::vpcOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::vpcOptions)).constructor(AwsElasticsearchDomainVPCOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICIES_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, ENDPOINT_FIELD, ENDPOINTS_FIELD, ELASTICSEARCH_VERSION_FIELD, ELASTICSEARCH_CLUSTER_CONFIG_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, SERVICE_SOFTWARE_OPTIONS_FIELD, VPC_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsElasticsearchDomainDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessPolicies;
    private final AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;
    private final String domainId;
    private final String domainName;
    private final String endpoint;
    private final Map<String, String> endpoints;
    private final String elasticsearchVersion;
    private final AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig;
    private final AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;
    private final AwsElasticsearchDomainLogPublishingOptions logPublishingOptions;
    private final AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private final AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions;
    private final AwsElasticsearchDomainVPCOptions vpcOptions;

    private AwsElasticsearchDomainDetails(BuilderImpl builder) {
        this.accessPolicies = builder.accessPolicies;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.endpoint = builder.endpoint;
        this.endpoints = builder.endpoints;
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
        this.vpcOptions = builder.vpcOptions;
    }

    public final String accessPolicies() {
        return this.accessPolicies;
    }

    public final AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> endpoints() {
        return this.endpoints;
    }

    public final String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public final AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public final AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final AwsElasticsearchDomainLogPublishingOptions logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public final AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public final AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions() {
        return this.serviceSoftwareOptions;
    }

    public final AwsElasticsearchDomainVPCOptions vpcOptions() {
        return this.vpcOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSoftwareOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainDetails)) {
            return false;
        }
        AwsElasticsearchDomainDetails other = (AwsElasticsearchDomainDetails)obj;
        return Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.endpoint(), other.endpoint()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.serviceSoftwareOptions(), other.serviceSoftwareOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElasticsearchDomainDetails").add("AccessPolicies", (Object)this.accessPolicies()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("Endpoint", (Object)this.endpoint()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("ServiceSoftwareOptions", (Object)this.serviceSoftwareOptions()).add("VPCOptions", (Object)this.vpcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "ElasticsearchVersion": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "ServiceSoftwareOptions": {
                return Optional.ofNullable(clazz.cast(this.serviceSoftwareOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessPolicies", ACCESS_POLICIES_FIELD);
        map.put("DomainEndpointOptions", DOMAIN_ENDPOINT_OPTIONS_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("Endpoints", ENDPOINTS_FIELD);
        map.put("ElasticsearchVersion", ELASTICSEARCH_VERSION_FIELD);
        map.put("ElasticsearchClusterConfig", ELASTICSEARCH_CLUSTER_CONFIG_FIELD);
        map.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
        map.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
        map.put("NodeToNodeEncryptionOptions", NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD);
        map.put("ServiceSoftwareOptions", SERVICE_SOFTWARE_OPTIONS_FIELD);
        map.put("VPCOptions", VPC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainDetails, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessPolicies;
        private AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;
        private String domainId;
        private String domainName;
        private String endpoint;
        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();
        private String elasticsearchVersion;
        private AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig;
        private AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;
        private AwsElasticsearchDomainLogPublishingOptions logPublishingOptions;
        private AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
        private AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions;
        private AwsElasticsearchDomainVPCOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainDetails model) {
            this.accessPolicies(model.accessPolicies);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.endpoint(model.endpoint);
            this.endpoints(model.endpoints);
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.logPublishingOptions(model.logPublishingOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.serviceSoftwareOptions(model.serviceSoftwareOptions);
            this.vpcOptions(model.vpcOptions);
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final AwsElasticsearchDomainDomainEndpointOptions.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Map<String, String> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.endpoints;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
            return this;
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        public final void setElasticsearchClusterConfig(AwsElasticsearchDomainElasticsearchClusterConfigDetails.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final AwsElasticsearchDomainEncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final AwsElasticsearchDomainLogPublishingOptions.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(AwsElasticsearchDomainLogPublishingOptions.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(AwsElasticsearchDomainLogPublishingOptions logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AwsElasticsearchDomainServiceSoftwareOptions.Builder getServiceSoftwareOptions() {
            return this.serviceSoftwareOptions != null ? this.serviceSoftwareOptions.toBuilder() : null;
        }

        public final void setServiceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        @Override
        public final Builder serviceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        public final AwsElasticsearchDomainVPCOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(AwsElasticsearchDomainVPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(AwsElasticsearchDomainVPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public AwsElasticsearchDomainDetails build() {
            return new AwsElasticsearchDomainDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElasticsearchDomainDetails> {
        public Builder accessPolicies(String var1);

        public Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions var1);

        default public Builder domainEndpointOptions(Consumer<AwsElasticsearchDomainDomainEndpointOptions.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((AwsElasticsearchDomainDomainEndpointOptions)((AwsElasticsearchDomainDomainEndpointOptions.Builder)AwsElasticsearchDomainDomainEndpointOptions.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder endpoint(String var1);

        public Builder endpoints(Map<String, String> var1);

        public Builder elasticsearchVersion(String var1);

        public Builder elasticsearchClusterConfig(AwsElasticsearchDomainElasticsearchClusterConfigDetails var1);

        default public Builder elasticsearchClusterConfig(Consumer<AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((AwsElasticsearchDomainElasticsearchClusterConfigDetails)((AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder)AwsElasticsearchDomainElasticsearchClusterConfigDetails.builder().applyMutation(elasticsearchClusterConfig)).build());
        }

        public Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<AwsElasticsearchDomainEncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((AwsElasticsearchDomainEncryptionAtRestOptions)((AwsElasticsearchDomainEncryptionAtRestOptions.Builder)AwsElasticsearchDomainEncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder logPublishingOptions(AwsElasticsearchDomainLogPublishingOptions var1);

        default public Builder logPublishingOptions(Consumer<AwsElasticsearchDomainLogPublishingOptions.Builder> logPublishingOptions) {
            return this.logPublishingOptions((AwsElasticsearchDomainLogPublishingOptions)((AwsElasticsearchDomainLogPublishingOptions.Builder)AwsElasticsearchDomainLogPublishingOptions.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((AwsElasticsearchDomainNodeToNodeEncryptionOptions)((AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder)AwsElasticsearchDomainNodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder serviceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions var1);

        default public Builder serviceSoftwareOptions(Consumer<AwsElasticsearchDomainServiceSoftwareOptions.Builder> serviceSoftwareOptions) {
            return this.serviceSoftwareOptions((AwsElasticsearchDomainServiceSoftwareOptions)((AwsElasticsearchDomainServiceSoftwareOptions.Builder)AwsElasticsearchDomainServiceSoftwareOptions.builder().applyMutation(serviceSoftwareOptions)).build());
        }

        public Builder vpcOptions(AwsElasticsearchDomainVPCOptions var1);

        default public Builder vpcOptions(Consumer<AwsElasticsearchDomainVPCOptions.Builder> vpcOptions) {
            return this.vpcOptions((AwsElasticsearchDomainVPCOptions)((AwsElasticsearchDomainVPCOptions.Builder)AwsElasticsearchDomainVPCOptions.builder().applyMutation(vpcOptions)).build());
        }
    }
}

