/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.secretsmanager.model.APIErrorListTypeCopier;
import software.amazon.awssdk.services.secretsmanager.model.APIErrorType;
import software.amazon.awssdk.services.secretsmanager.model.SecretValueEntry;
import software.amazon.awssdk.services.secretsmanager.model.SecretValuesTypeCopier;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetSecretValueResponse
extends SecretsManagerResponse
implements ToCopyableBuilder<Builder, BatchGetSecretValueResponse> {
    private static final SdkField<List<SecretValueEntry>> SECRET_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecretValues").getter(BatchGetSecretValueResponse.getter(BatchGetSecretValueResponse::secretValues)).setter(BatchGetSecretValueResponse.setter(Builder::secretValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecretValueEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchGetSecretValueResponse.getter(BatchGetSecretValueResponse::nextToken)).setter(BatchGetSecretValueResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<APIErrorType>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetSecretValueResponse.getter(BatchGetSecretValueResponse::errors)).setter(BatchGetSecretValueResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(APIErrorType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_VALUES_FIELD, NEXT_TOKEN_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetSecretValueResponse.memberNameToFieldInitializer();
    private final List<SecretValueEntry> secretValues;
    private final String nextToken;
    private final List<APIErrorType> errors;

    private BatchGetSecretValueResponse(BuilderImpl builder) {
        super(builder);
        this.secretValues = builder.secretValues;
        this.nextToken = builder.nextToken;
        this.errors = builder.errors;
    }

    public final boolean hasSecretValues() {
        return this.secretValues != null && !(this.secretValues instanceof SdkAutoConstructList);
    }

    public final List<SecretValueEntry> secretValues() {
        return this.secretValues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<APIErrorType> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecretValues() ? this.secretValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSecretValueResponse)) {
            return false;
        }
        BatchGetSecretValueResponse other = (BatchGetSecretValueResponse)((Object)obj);
        return this.hasSecretValues() == other.hasSecretValues() && Objects.equals(this.secretValues(), other.secretValues()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetSecretValueResponse").add("SecretValues", this.hasSecretValues() ? this.secretValues() : null).add("NextToken", (Object)this.nextToken()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretValues": {
                return Optional.ofNullable(clazz.cast(this.secretValues()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SecretValues", SECRET_VALUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSecretValueResponse, T> g) {
        return obj -> g.apply((BatchGetSecretValueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecretsManagerResponse.BuilderImpl
    implements Builder {
        private List<SecretValueEntry> secretValues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<APIErrorType> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSecretValueResponse model) {
            super(model);
            this.secretValues(model.secretValues);
            this.nextToken(model.nextToken);
            this.errors(model.errors);
        }

        public final List<SecretValueEntry.Builder> getSecretValues() {
            List<SecretValueEntry.Builder> result = SecretValuesTypeCopier.copyToBuilder(this.secretValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecretValues(Collection<SecretValueEntry.BuilderImpl> secretValues) {
            this.secretValues = SecretValuesTypeCopier.copyFromBuilder(secretValues);
        }

        @Override
        public final Builder secretValues(Collection<SecretValueEntry> secretValues) {
            this.secretValues = SecretValuesTypeCopier.copy(secretValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretValues(SecretValueEntry ... secretValues) {
            this.secretValues(Arrays.asList(secretValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretValues(Consumer<SecretValueEntry.Builder> ... secretValues) {
            this.secretValues(Stream.of(secretValues).map(c -> (SecretValueEntry)((SecretValueEntry.Builder)SecretValueEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<APIErrorType.Builder> getErrors() {
            List<APIErrorType.Builder> result = APIErrorListTypeCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<APIErrorType.BuilderImpl> errors) {
            this.errors = APIErrorListTypeCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<APIErrorType> errors) {
            this.errors = APIErrorListTypeCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(APIErrorType ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<APIErrorType.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (APIErrorType)((APIErrorType.Builder)APIErrorType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSecretValueResponse build() {
            return new BatchGetSecretValueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecretsManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetSecretValueResponse> {
        public Builder secretValues(Collection<SecretValueEntry> var1);

        public Builder secretValues(SecretValueEntry ... var1);

        public Builder secretValues(Consumer<SecretValueEntry.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder errors(Collection<APIErrorType> var1);

        public Builder errors(APIErrorType ... var1);

        public Builder errors(Consumer<APIErrorType.Builder> ... var1);
    }
}

