/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueResponse;

public class BatchGetSecretValueIterable
implements SdkIterable<BatchGetSecretValueResponse> {
    private final SecretsManagerClient client;
    private final BatchGetSecretValueRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetSecretValueIterable(SecretsManagerClient client, BatchGetSecretValueRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new BatchGetSecretValueResponseFetcher();
    }

    public Iterator<BatchGetSecretValueResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class BatchGetSecretValueResponseFetcher
    implements SyncPageFetcher<BatchGetSecretValueResponse> {
        private BatchGetSecretValueResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetSecretValueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public BatchGetSecretValueResponse nextPage(BatchGetSecretValueResponse previousPage) {
            if (previousPage == null) {
                return BatchGetSecretValueIterable.this.client.batchGetSecretValue(BatchGetSecretValueIterable.this.firstRequest);
            }
            return BatchGetSecretValueIterable.this.client.batchGetSecretValue((BatchGetSecretValueRequest)((Object)BatchGetSecretValueIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

