/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The error Secrets Manager encountered while retrieving an individual secret as part of <a>BatchGetSecretValue</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class APIErrorType implements SdkPojo, Serializable, ToCopyableBuilder<APIErrorType.Builder, APIErrorType> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(APIErrorType::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(APIErrorType::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(APIErrorType::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_ID_FIELD,
            ERROR_CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String secretId;

    private final String errorCode;

    private final String message;

    private APIErrorType(BuilderImpl builder) {
        this.secretId = builder.secretId;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * The ARN or name of the secret.
     * </p>
     * 
     * @return The ARN or name of the secret.
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * <p>
     * The error Secrets Manager encountered while retrieving an individual secret as part of
     * <a>BatchGetSecretValue</a>, for example <code>ResourceNotFoundException</code>,
     * <code>InvalidParameterException</code>, <code>InvalidRequestException</code>, <code>DecryptionFailure</code>, or
     * <code>AccessDeniedException</code>.
     * </p>
     * 
     * @return The error Secrets Manager encountered while retrieving an individual secret as part of
     *         <a>BatchGetSecretValue</a>, for example <code>ResourceNotFoundException</code>,
     *         <code>InvalidParameterException</code>, <code>InvalidRequestException</code>,
     *         <code>DecryptionFailure</code>, or <code>AccessDeniedException</code>.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A message describing the error.
     * </p>
     * 
     * @return A message describing the error.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APIErrorType)) {
            return false;
        }
        APIErrorType other = (APIErrorType) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("APIErrorType").add("SecretId", secretId()).add("ErrorCode", errorCode())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APIErrorType, T> g) {
        return obj -> g.apply((APIErrorType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, APIErrorType> {
        /**
         * <p>
         * The ARN or name of the secret.
         * </p>
         * 
         * @param secretId
         *        The ARN or name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * The error Secrets Manager encountered while retrieving an individual secret as part of
         * <a>BatchGetSecretValue</a>, for example <code>ResourceNotFoundException</code>,
         * <code>InvalidParameterException</code>, <code>InvalidRequestException</code>, <code>DecryptionFailure</code>,
         * or <code>AccessDeniedException</code>.
         * </p>
         * 
         * @param errorCode
         *        The error Secrets Manager encountered while retrieving an individual secret as part of
         *        <a>BatchGetSecretValue</a>, for example <code>ResourceNotFoundException</code>,
         *        <code>InvalidParameterException</code>, <code>InvalidRequestException</code>,
         *        <code>DecryptionFailure</code>, or <code>AccessDeniedException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A message describing the error.
         * </p>
         * 
         * @param message
         *        A message describing the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String secretId;

        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(APIErrorType model) {
            secretId(model.secretId);
            errorCode(model.errorCode);
            message(model.message);
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public APIErrorType build() {
            return new APIErrorType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
