/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.schemas.model.DiscovererState;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDiscovererResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, StartDiscovererResponse> {
    private static final SdkField<String> DISCOVERER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscovererId").getter(StartDiscovererResponse.getter(StartDiscovererResponse::discovererId)).setter(StartDiscovererResponse.setter(Builder::discovererId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(StartDiscovererResponse.getter(StartDiscovererResponse::stateAsString)).setter(StartDiscovererResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERER_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDiscovererResponse.memberNameToFieldInitializer();
    private final String discovererId;
    private final String state;

    private StartDiscovererResponse(BuilderImpl builder) {
        super(builder);
        this.discovererId = builder.discovererId;
        this.state = builder.state;
    }

    public final String discovererId() {
        return this.discovererId;
    }

    public final DiscovererState state() {
        return DiscovererState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.discovererId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDiscovererResponse)) {
            return false;
        }
        StartDiscovererResponse other = (StartDiscovererResponse)((Object)obj);
        return Objects.equals(this.discovererId(), other.discovererId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartDiscovererResponse").add("DiscovererId", (Object)this.discovererId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiscovererId": {
                return Optional.ofNullable(clazz.cast(this.discovererId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DiscovererId", DISCOVERER_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDiscovererResponse, T> g) {
        return obj -> g.apply((StartDiscovererResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String discovererId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDiscovererResponse model) {
            super(model);
            this.discovererId(model.discovererId);
            this.state(model.state);
        }

        public final String getDiscovererId() {
            return this.discovererId;
        }

        public final void setDiscovererId(String discovererId) {
            this.discovererId = discovererId;
        }

        @Override
        public final Builder discovererId(String discovererId) {
            this.discovererId = discovererId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiscovererState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public StartDiscovererResponse build() {
            return new StartDiscovererResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDiscovererResponse> {
        public Builder discovererId(String var1);

        public Builder state(String var1);

        public Builder state(DiscovererState var1);
    }
}

