/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.schemas.model.RegistrySummary;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.___listOfRegistrySummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegistriesResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, ListRegistriesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegistriesResponse.getter(ListRegistriesResponse::nextToken)).setter(ListRegistriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RegistrySummary>> REGISTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Registries").getter(ListRegistriesResponse.getter(ListRegistriesResponse::registries)).setter(ListRegistriesResponse.setter(Builder::registries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Registries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistrySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REGISTRIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRegistriesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RegistrySummary> registries;

    private ListRegistriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.registries = builder.registries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRegistries() {
        return this.registries != null && !(this.registries instanceof SdkAutoConstructList);
    }

    public final List<RegistrySummary> registries() {
        return this.registries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistries() ? this.registries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistriesResponse)) {
            return false;
        }
        ListRegistriesResponse other = (ListRegistriesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRegistries() == other.hasRegistries() && Objects.equals(this.registries(), other.registries());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegistriesResponse").add("NextToken", (Object)this.nextToken()).add("Registries", this.hasRegistries() ? this.registries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Registries": {
                return Optional.ofNullable(clazz.cast(this.registries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Registries", REGISTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegistriesResponse, T> g) {
        return obj -> g.apply((ListRegistriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RegistrySummary> registries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegistriesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.registries(model.registries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RegistrySummary.Builder> getRegistries() {
            List<RegistrySummary.Builder> result = ___listOfRegistrySummaryCopier.copyToBuilder(this.registries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistries(Collection<RegistrySummary.BuilderImpl> registries) {
            this.registries = ___listOfRegistrySummaryCopier.copyFromBuilder(registries);
        }

        @Override
        public final Builder registries(Collection<RegistrySummary> registries) {
            this.registries = ___listOfRegistrySummaryCopier.copy(registries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(RegistrySummary ... registries) {
            this.registries(Arrays.asList(registries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Consumer<RegistrySummary.Builder> ... registries) {
            this.registries(Stream.of(registries).map(c -> (RegistrySummary)((RegistrySummary.Builder)RegistrySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegistriesResponse build() {
            return new ListRegistriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegistriesResponse> {
        public Builder nextToken(String var1);

        public Builder registries(Collection<RegistrySummary> var1);

        public Builder registries(RegistrySummary ... var1);

        public Builder registries(Consumer<RegistrySummary.Builder> ... var1);
    }
}

