/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.schemas.model.SchemasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRegistriesRequest
extends SchemasRequest
implements ToCopyableBuilder<Builder, ListRegistriesRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(ListRegistriesRequest.getter(ListRegistriesRequest::limit)).setter(ListRegistriesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRegistriesRequest.getter(ListRegistriesRequest::nextToken)).setter(ListRegistriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> REGISTRY_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryNamePrefix").getter(ListRegistriesRequest.getter(ListRegistriesRequest::registryNamePrefix)).setter(ListRegistriesRequest.setter(Builder::registryNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("registryNamePrefix").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(ListRegistriesRequest.getter(ListRegistriesRequest::scope)).setter(ListRegistriesRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, NEXT_TOKEN_FIELD, REGISTRY_NAME_PREFIX_FIELD, SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRegistriesRequest.memberNameToFieldInitializer();
    private final Integer limit;
    private final String nextToken;
    private final String registryNamePrefix;
    private final String scope;

    private ListRegistriesRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.registryNamePrefix = builder.registryNamePrefix;
        this.scope = builder.scope;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String registryNamePrefix() {
        return this.registryNamePrefix;
    }

    public final String scope() {
        return this.scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistriesRequest)) {
            return false;
        }
        ListRegistriesRequest other = (ListRegistriesRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.registryNamePrefix(), other.registryNamePrefix()) && Objects.equals(this.scope(), other.scope());
    }

    public final String toString() {
        return ToString.builder((String)"ListRegistriesRequest").add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).add("RegistryNamePrefix", (Object)this.registryNamePrefix()).add("Scope", (Object)this.scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RegistryNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.registryNamePrefix()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("limit", LIMIT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("registryNamePrefix", REGISTRY_NAME_PREFIX_FIELD);
        map.put("scope", SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRegistriesRequest, T> g) {
        return obj -> g.apply((ListRegistriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private String nextToken;
        private String registryNamePrefix;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegistriesRequest model) {
            super(model);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
            this.registryNamePrefix(model.registryNamePrefix);
            this.scope(model.scope);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRegistryNamePrefix() {
            return this.registryNamePrefix;
        }

        public final void setRegistryNamePrefix(String registryNamePrefix) {
            this.registryNamePrefix = registryNamePrefix;
        }

        @Override
        public final Builder registryNamePrefix(String registryNamePrefix) {
            this.registryNamePrefix = registryNamePrefix;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRegistriesRequest build() {
            return new ListRegistriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SchemasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRegistriesRequest> {
        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder registryNamePrefix(String var1);

        public Builder scope(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

