/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.savingsplans.model.CurrencyCode;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductTypeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanState;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanType;
import software.amazon.awssdk.services.savingsplans.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlan
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlan> {
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offeringId").getter(SavingsPlan.getter(SavingsPlan::offeringId)).setter(SavingsPlan.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()}).build();
    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsPlanId").getter(SavingsPlan.getter(SavingsPlan::savingsPlanId)).setter(SavingsPlan.setter(Builder::savingsPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()}).build();
    private static final SdkField<String> SAVINGS_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsPlanArn").getter(SavingsPlan.getter(SavingsPlan::savingsPlanArn)).setter(SavingsPlan.setter(Builder::savingsPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SavingsPlan.getter(SavingsPlan::description)).setter(SavingsPlan.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("start").getter(SavingsPlan.getter(SavingsPlan::start)).setter(SavingsPlan.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()}).build();
    private static final SdkField<String> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("end").getter(SavingsPlan.getter(SavingsPlan::end)).setter(SavingsPlan.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(SavingsPlan.getter(SavingsPlan::stateAsString)).setter(SavingsPlan.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(SavingsPlan.getter(SavingsPlan::region)).setter(SavingsPlan.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2InstanceFamily").getter(SavingsPlan.getter(SavingsPlan::ec2InstanceFamily)).setter(SavingsPlan.setter(Builder::ec2InstanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceFamily").build()}).build();
    private static final SdkField<String> SAVINGS_PLAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("savingsPlanType").getter(SavingsPlan.getter(SavingsPlan::savingsPlanTypeAsString)).setter(SavingsPlan.setter(Builder::savingsPlanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanType").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("paymentOption").getter(SavingsPlan.getter(SavingsPlan::paymentOptionAsString)).setter(SavingsPlan.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()}).build();
    private static final SdkField<List<String>> PRODUCT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("productTypes").getter(SavingsPlan.getter(SavingsPlan::productTypesAsStrings)).setter(SavingsPlan.setter(Builder::productTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(SavingsPlan.getter(SavingsPlan::currencyAsString)).setter(SavingsPlan.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitment").getter(SavingsPlan.getter(SavingsPlan::commitment)).setter(SavingsPlan.setter(Builder::commitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()}).build();
    private static final SdkField<String> UPFRONT_PAYMENT_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upfrontPaymentAmount").getter(SavingsPlan.getter(SavingsPlan::upfrontPaymentAmount)).setter(SavingsPlan.setter(Builder::upfrontPaymentAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontPaymentAmount").build()}).build();
    private static final SdkField<String> RECURRING_PAYMENT_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recurringPaymentAmount").getter(SavingsPlan.getter(SavingsPlan::recurringPaymentAmount)).setter(SavingsPlan.setter(Builder::recurringPaymentAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recurringPaymentAmount").build()}).build();
    private static final SdkField<Long> TERM_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("termDurationInSeconds").getter(SavingsPlan.getter(SavingsPlan::termDurationInSeconds)).setter(SavingsPlan.setter(Builder::termDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termDurationInSeconds").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SavingsPlan.getter(SavingsPlan::tags)).setter(SavingsPlan.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ID_FIELD, SAVINGS_PLAN_ID_FIELD, SAVINGS_PLAN_ARN_FIELD, DESCRIPTION_FIELD, START_FIELD, END_FIELD, STATE_FIELD, REGION_FIELD, EC2_INSTANCE_FAMILY_FIELD, SAVINGS_PLAN_TYPE_FIELD, PAYMENT_OPTION_FIELD, PRODUCT_TYPES_FIELD, CURRENCY_FIELD, COMMITMENT_FIELD, UPFRONT_PAYMENT_AMOUNT_FIELD, RECURRING_PAYMENT_AMOUNT_FIELD, TERM_DURATION_IN_SECONDS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String offeringId;
    private final String savingsPlanId;
    private final String savingsPlanArn;
    private final String description;
    private final String start;
    private final String end;
    private final String state;
    private final String region;
    private final String ec2InstanceFamily;
    private final String savingsPlanType;
    private final String paymentOption;
    private final List<String> productTypes;
    private final String currency;
    private final String commitment;
    private final String upfrontPaymentAmount;
    private final String recurringPaymentAmount;
    private final Long termDurationInSeconds;
    private final Map<String, String> tags;

    private SavingsPlan(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.savingsPlanId = builder.savingsPlanId;
        this.savingsPlanArn = builder.savingsPlanArn;
        this.description = builder.description;
        this.start = builder.start;
        this.end = builder.end;
        this.state = builder.state;
        this.region = builder.region;
        this.ec2InstanceFamily = builder.ec2InstanceFamily;
        this.savingsPlanType = builder.savingsPlanType;
        this.paymentOption = builder.paymentOption;
        this.productTypes = builder.productTypes;
        this.currency = builder.currency;
        this.commitment = builder.commitment;
        this.upfrontPaymentAmount = builder.upfrontPaymentAmount;
        this.recurringPaymentAmount = builder.recurringPaymentAmount;
        this.termDurationInSeconds = builder.termDurationInSeconds;
        this.tags = builder.tags;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final String savingsPlanId() {
        return this.savingsPlanId;
    }

    public final String savingsPlanArn() {
        return this.savingsPlanArn;
    }

    public final String description() {
        return this.description;
    }

    public final String start() {
        return this.start;
    }

    public final String end() {
        return this.end;
    }

    public final SavingsPlanState state() {
        return SavingsPlanState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String region() {
        return this.region;
    }

    public final String ec2InstanceFamily() {
        return this.ec2InstanceFamily;
    }

    public final SavingsPlanType savingsPlanType() {
        return SavingsPlanType.fromValue(this.savingsPlanType);
    }

    public final String savingsPlanTypeAsString() {
        return this.savingsPlanType;
    }

    public final SavingsPlanPaymentOption paymentOption() {
        return SavingsPlanPaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final List<SavingsPlanProductType> productTypes() {
        return SavingsPlanProductTypeListCopier.copyStringToEnum(this.productTypes);
    }

    public final boolean hasProductTypes() {
        return this.productTypes != null && !(this.productTypes instanceof SdkAutoConstructList);
    }

    public final List<String> productTypesAsStrings() {
        return this.productTypes;
    }

    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final String commitment() {
        return this.commitment;
    }

    public final String upfrontPaymentAmount() {
        return this.upfrontPaymentAmount;
    }

    public final String recurringPaymentAmount() {
        return this.recurringPaymentAmount;
    }

    public final Long termDurationInSeconds() {
        return this.termDurationInSeconds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductTypes() ? this.productTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.termDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlan)) {
            return false;
        }
        SavingsPlan other = (SavingsPlan)obj;
        return Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.savingsPlanId(), other.savingsPlanId()) && Objects.equals(this.savingsPlanArn(), other.savingsPlanArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.ec2InstanceFamily(), other.ec2InstanceFamily()) && Objects.equals(this.savingsPlanTypeAsString(), other.savingsPlanTypeAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && this.hasProductTypes() == other.hasProductTypes() && Objects.equals(this.productTypesAsStrings(), other.productTypesAsStrings()) && Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.commitment(), other.commitment()) && Objects.equals(this.upfrontPaymentAmount(), other.upfrontPaymentAmount()) && Objects.equals(this.recurringPaymentAmount(), other.recurringPaymentAmount()) && Objects.equals(this.termDurationInSeconds(), other.termDurationInSeconds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlan").add("OfferingId", (Object)this.offeringId()).add("SavingsPlanId", (Object)this.savingsPlanId()).add("SavingsPlanArn", (Object)this.savingsPlanArn()).add("Description", (Object)this.description()).add("Start", (Object)this.start()).add("End", (Object)this.end()).add("State", (Object)this.stateAsString()).add("Region", (Object)this.region()).add("Ec2InstanceFamily", (Object)this.ec2InstanceFamily()).add("SavingsPlanType", (Object)this.savingsPlanTypeAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("ProductTypes", this.hasProductTypes() ? this.productTypesAsStrings() : null).add("Currency", (Object)this.currencyAsString()).add("Commitment", (Object)this.commitment()).add("UpfrontPaymentAmount", (Object)this.upfrontPaymentAmount()).add("RecurringPaymentAmount", (Object)this.recurringPaymentAmount()).add("TermDurationInSeconds", (Object)this.termDurationInSeconds()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "savingsPlanId": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanId()));
            }
            case "savingsPlanArn": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "end": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ec2InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceFamily()));
            }
            case "savingsPlanType": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanTypeAsString()));
            }
            case "paymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "productTypes": {
                return Optional.ofNullable(clazz.cast(this.productTypesAsStrings()));
            }
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "commitment": {
                return Optional.ofNullable(clazz.cast(this.commitment()));
            }
            case "upfrontPaymentAmount": {
                return Optional.ofNullable(clazz.cast(this.upfrontPaymentAmount()));
            }
            case "recurringPaymentAmount": {
                return Optional.ofNullable(clazz.cast(this.recurringPaymentAmount()));
            }
            case "termDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.termDurationInSeconds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlan, T> g) {
        return obj -> g.apply((SavingsPlan)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String offeringId;
        private String savingsPlanId;
        private String savingsPlanArn;
        private String description;
        private String start;
        private String end;
        private String state;
        private String region;
        private String ec2InstanceFamily;
        private String savingsPlanType;
        private String paymentOption;
        private List<String> productTypes = DefaultSdkAutoConstructList.getInstance();
        private String currency;
        private String commitment;
        private String upfrontPaymentAmount;
        private String recurringPaymentAmount;
        private Long termDurationInSeconds;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlan model) {
            this.offeringId(model.offeringId);
            this.savingsPlanId(model.savingsPlanId);
            this.savingsPlanArn(model.savingsPlanArn);
            this.description(model.description);
            this.start(model.start);
            this.end(model.end);
            this.state(model.state);
            this.region(model.region);
            this.ec2InstanceFamily(model.ec2InstanceFamily);
            this.savingsPlanType(model.savingsPlanType);
            this.paymentOption(model.paymentOption);
            this.productTypesWithStrings(model.productTypes);
            this.currency(model.currency);
            this.commitment(model.commitment);
            this.upfrontPaymentAmount(model.upfrontPaymentAmount);
            this.recurringPaymentAmount(model.recurringPaymentAmount);
            this.termDurationInSeconds(model.termDurationInSeconds);
            this.tags(model.tags);
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        @Transient
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getSavingsPlanId() {
            return this.savingsPlanId;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        @Override
        @Transient
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        public final String getSavingsPlanArn() {
            return this.savingsPlanArn;
        }

        public final void setSavingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
        }

        @Override
        @Transient
        public final Builder savingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStart() {
            return this.start;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        @Override
        @Transient
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final String getEnd() {
            return this.end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        @Transient
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(SavingsPlanState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getEc2InstanceFamily() {
            return this.ec2InstanceFamily;
        }

        public final void setEc2InstanceFamily(String ec2InstanceFamily) {
            this.ec2InstanceFamily = ec2InstanceFamily;
        }

        @Override
        @Transient
        public final Builder ec2InstanceFamily(String ec2InstanceFamily) {
            this.ec2InstanceFamily = ec2InstanceFamily;
            return this;
        }

        public final String getSavingsPlanType() {
            return this.savingsPlanType;
        }

        public final void setSavingsPlanType(String savingsPlanType) {
            this.savingsPlanType = savingsPlanType;
        }

        @Override
        @Transient
        public final Builder savingsPlanType(String savingsPlanType) {
            this.savingsPlanType = savingsPlanType;
            return this;
        }

        @Override
        @Transient
        public final Builder savingsPlanType(SavingsPlanType savingsPlanType) {
            this.savingsPlanType(savingsPlanType == null ? null : savingsPlanType.toString());
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(SavingsPlanPaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final Collection<String> getProductTypes() {
            if (this.productTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productTypes;
        }

        public final void setProductTypes(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
        }

        @Override
        @Transient
        public final Builder productTypesWithStrings(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productTypesWithStrings(String ... productTypes) {
            this.productTypesWithStrings(Arrays.asList(productTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder productTypes(Collection<SavingsPlanProductType> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copyEnumToString(productTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productTypes(SavingsPlanProductType ... productTypes) {
            this.productTypes(Arrays.asList(productTypes));
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        @Transient
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        @Transient
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getCommitment() {
            return this.commitment;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        @Override
        @Transient
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        public final String getUpfrontPaymentAmount() {
            return this.upfrontPaymentAmount;
        }

        public final void setUpfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
        }

        @Override
        @Transient
        public final Builder upfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
            return this;
        }

        public final String getRecurringPaymentAmount() {
            return this.recurringPaymentAmount;
        }

        public final void setRecurringPaymentAmount(String recurringPaymentAmount) {
            this.recurringPaymentAmount = recurringPaymentAmount;
        }

        @Override
        @Transient
        public final Builder recurringPaymentAmount(String recurringPaymentAmount) {
            this.recurringPaymentAmount = recurringPaymentAmount;
            return this;
        }

        public final Long getTermDurationInSeconds() {
            return this.termDurationInSeconds;
        }

        public final void setTermDurationInSeconds(Long termDurationInSeconds) {
            this.termDurationInSeconds = termDurationInSeconds;
        }

        @Override
        @Transient
        public final Builder termDurationInSeconds(Long termDurationInSeconds) {
            this.termDurationInSeconds = termDurationInSeconds;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public SavingsPlan build() {
            return new SavingsPlan(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlan> {
        public Builder offeringId(String var1);

        public Builder savingsPlanId(String var1);

        public Builder savingsPlanArn(String var1);

        public Builder description(String var1);

        public Builder start(String var1);

        public Builder end(String var1);

        public Builder state(String var1);

        public Builder state(SavingsPlanState var1);

        public Builder region(String var1);

        public Builder ec2InstanceFamily(String var1);

        public Builder savingsPlanType(String var1);

        public Builder savingsPlanType(SavingsPlanType var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(SavingsPlanPaymentOption var1);

        public Builder productTypesWithStrings(Collection<String> var1);

        public Builder productTypesWithStrings(String ... var1);

        public Builder productTypes(Collection<SavingsPlanProductType> var1);

        public Builder productTypes(SavingsPlanProductType ... var1);

        public Builder currency(String var1);

        public Builder currency(CurrencyCode var1);

        public Builder commitment(String var1);

        public Builder upfrontPaymentAmount(String var1);

        public Builder recurringPaymentAmount(String var1);

        public Builder termDurationInSeconds(Long var1);

        public Builder tags(Map<String, String> var1);
    }
}

