/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSavingsPlanRequest extends SavingsplansRequest implements
        ToCopyableBuilder<CreateSavingsPlanRequest.Builder, CreateSavingsPlanRequest> {
    private static final SdkField<String> SAVINGS_PLAN_OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanOfferingId").getter(getter(CreateSavingsPlanRequest::savingsPlanOfferingId))
            .setter(setter(Builder::savingsPlanOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanOfferingId").build())
            .build();

    private static final SdkField<String> COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitment").getter(getter(CreateSavingsPlanRequest::commitment)).setter(setter(Builder::commitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()).build();

    private static final SdkField<String> UPFRONT_PAYMENT_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upfrontPaymentAmount").getter(getter(CreateSavingsPlanRequest::upfrontPaymentAmount))
            .setter(setter(Builder::upfrontPaymentAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontPaymentAmount").build())
            .build();

    private static final SdkField<Instant> PURCHASE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("purchaseTime").getter(getter(CreateSavingsPlanRequest::purchaseTime))
            .setter(setter(Builder::purchaseTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseTime").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSavingsPlanRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSavingsPlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_PLAN_OFFERING_ID_FIELD, COMMITMENT_FIELD, UPFRONT_PAYMENT_AMOUNT_FIELD, PURCHASE_TIME_FIELD,
            CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String savingsPlanOfferingId;

    private final String commitment;

    private final String upfrontPaymentAmount;

    private final Instant purchaseTime;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateSavingsPlanRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanOfferingId = builder.savingsPlanOfferingId;
        this.commitment = builder.commitment;
        this.upfrontPaymentAmount = builder.upfrontPaymentAmount;
        this.purchaseTime = builder.purchaseTime;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public final String savingsPlanOfferingId() {
        return savingsPlanOfferingId;
    }

    /**
     * <p>
     * The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five
     * digits after the decimal point.
     * </p>
     * 
     * @return The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than
     *         five digits after the decimal point.
     */
    public final String commitment() {
        return commitment;
    }

    /**
     * <p>
     * The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the Savings
     * Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.
     * </p>
     * 
     * @return The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the
     *         Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.
     */
    public final String upfrontPaymentAmount() {
        return upfrontPaymentAmount;
    }

    /**
     * <p>
     * The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).
     * </p>
     * 
     * @return The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).
     */
    public final Instant purchaseTime() {
        return purchaseTime;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(commitment());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseTime());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSavingsPlanRequest)) {
            return false;
        }
        CreateSavingsPlanRequest other = (CreateSavingsPlanRequest) obj;
        return Objects.equals(savingsPlanOfferingId(), other.savingsPlanOfferingId())
                && Objects.equals(commitment(), other.commitment())
                && Objects.equals(upfrontPaymentAmount(), other.upfrontPaymentAmount())
                && Objects.equals(purchaseTime(), other.purchaseTime()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSavingsPlanRequest").add("SavingsPlanOfferingId", savingsPlanOfferingId())
                .add("Commitment", commitment()).add("UpfrontPaymentAmount", upfrontPaymentAmount())
                .add("PurchaseTime", purchaseTime()).add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanOfferingId":
            return Optional.ofNullable(clazz.cast(savingsPlanOfferingId()));
        case "commitment":
            return Optional.ofNullable(clazz.cast(commitment()));
        case "upfrontPaymentAmount":
            return Optional.ofNullable(clazz.cast(upfrontPaymentAmount()));
        case "purchaseTime":
            return Optional.ofNullable(clazz.cast(purchaseTime()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSavingsPlanRequest, T> g) {
        return obj -> g.apply((CreateSavingsPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSavingsPlanRequest> {
        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param savingsPlanOfferingId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanOfferingId(String savingsPlanOfferingId);

        /**
         * <p>
         * The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more than five
         * digits after the decimal point.
         * </p>
         * 
         * @param commitment
         *        The hourly commitment, in USD. This is a value between 0.001 and 1 million. You cannot specify more
         *        than five digits after the decimal point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitment(String commitment);

        /**
         * <p>
         * The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of the
         * Savings Plan. This parameter is supported only if the payment option is <code>Partial Upfront</code>.
         * </p>
         * 
         * @param upfrontPaymentAmount
         *        The up-front payment amount. This is a whole number between 50 and 99 percent of the total value of
         *        the Savings Plan. This parameter is supported only if the payment option is
         *        <code>Partial Upfront</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPaymentAmount(String upfrontPaymentAmount);

        /**
         * <p>
         * The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).
         * </p>
         * 
         * @param purchaseTime
         *        The time at which to purchase the Savings Plan, in UTC format (YYYY-MM-DDTHH:MM:SSZ).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchaseTime(Instant purchaseTime);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SavingsplansRequest.BuilderImpl implements Builder {
        private String savingsPlanOfferingId;

        private String commitment;

        private String upfrontPaymentAmount;

        private Instant purchaseTime;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSavingsPlanRequest model) {
            super(model);
            savingsPlanOfferingId(model.savingsPlanOfferingId);
            commitment(model.commitment);
            upfrontPaymentAmount(model.upfrontPaymentAmount);
            purchaseTime(model.purchaseTime);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getSavingsPlanOfferingId() {
            return savingsPlanOfferingId;
        }

        public final void setSavingsPlanOfferingId(String savingsPlanOfferingId) {
            this.savingsPlanOfferingId = savingsPlanOfferingId;
        }

        @Override
        @Transient
        public final Builder savingsPlanOfferingId(String savingsPlanOfferingId) {
            this.savingsPlanOfferingId = savingsPlanOfferingId;
            return this;
        }

        public final String getCommitment() {
            return commitment;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        @Override
        @Transient
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        public final String getUpfrontPaymentAmount() {
            return upfrontPaymentAmount;
        }

        public final void setUpfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
        }

        @Override
        @Transient
        public final Builder upfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
            return this;
        }

        public final Instant getPurchaseTime() {
            return purchaseTime;
        }

        public final void setPurchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
        }

        @Override
        @Transient
        public final Builder purchaseTime(Instant purchaseTime) {
            this.purchaseTime = purchaseTime;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSavingsPlanRequest build() {
            return new CreateSavingsPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
