/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobErrorDetails;
import software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobExportStatus;
import software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobOutputBandsCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobStatus;
import software.amazon.awssdk.services.sagemakergeospatial.model.ExportErrorDetails;
import software.amazon.awssdk.services.sagemakergeospatial.model.InputConfigOutput;
import software.amazon.awssdk.services.sagemakergeospatial.model.JobConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputBand;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEarthObservationJobResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, GetEarthObservationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::arn)).setter(GetEarthObservationJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::creationTime)).setter(GetEarthObservationJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationInSeconds").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::durationInSeconds)).setter(GetEarthObservationJobResponse.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final SdkField<EarthObservationJobErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetails").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::errorDetails)).setter(GetEarthObservationJobResponse.setter(Builder::errorDetails)).constructor(EarthObservationJobErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::executionRoleArn)).setter(GetEarthObservationJobResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<ExportErrorDetails> EXPORT_ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportErrorDetails").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::exportErrorDetails)).setter(GetEarthObservationJobResponse.setter(Builder::exportErrorDetails)).constructor(ExportErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportErrorDetails").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportStatus").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::exportStatusAsString)).setter(GetEarthObservationJobResponse.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final SdkField<InputConfigOutput> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::inputConfig)).setter(GetEarthObservationJobResponse.setter(Builder::inputConfig)).constructor(InputConfigOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<JobConfigInput> JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobConfig").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::jobConfig)).setter(GetEarthObservationJobResponse.setter(Builder::jobConfig)).constructor(JobConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::kmsKeyId)).setter(GetEarthObservationJobResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::name)).setter(GetEarthObservationJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<OutputBand>> OUTPUT_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputBands").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::outputBands)).setter(GetEarthObservationJobResponse.setter(Builder::outputBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputBand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::statusAsString)).setter(GetEarthObservationJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetEarthObservationJobResponse.getter(GetEarthObservationJobResponse::tags)).setter(GetEarthObservationJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, DURATION_IN_SECONDS_FIELD, ERROR_DETAILS_FIELD, EXECUTION_ROLE_ARN_FIELD, EXPORT_ERROR_DETAILS_FIELD, EXPORT_STATUS_FIELD, INPUT_CONFIG_FIELD, JOB_CONFIG_FIELD, KMS_KEY_ID_FIELD, NAME_FIELD, OUTPUT_BANDS_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEarthObservationJobResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant creationTime;
    private final Integer durationInSeconds;
    private final EarthObservationJobErrorDetails errorDetails;
    private final String executionRoleArn;
    private final ExportErrorDetails exportErrorDetails;
    private final String exportStatus;
    private final InputConfigOutput inputConfig;
    private final JobConfigInput jobConfig;
    private final String kmsKeyId;
    private final String name;
    private final List<OutputBand> outputBands;
    private final String status;
    private final Map<String, String> tags;

    private GetEarthObservationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.errorDetails = builder.errorDetails;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportErrorDetails = builder.exportErrorDetails;
        this.exportStatus = builder.exportStatus;
        this.inputConfig = builder.inputConfig;
        this.jobConfig = builder.jobConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.outputBands = builder.outputBands;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public final EarthObservationJobErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final ExportErrorDetails exportErrorDetails() {
        return this.exportErrorDetails;
    }

    public final EarthObservationJobExportStatus exportStatus() {
        return EarthObservationJobExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final InputConfigOutput inputConfig() {
        return this.inputConfig;
    }

    public final JobConfigInput jobConfig() {
        return this.jobConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasOutputBands() {
        return this.outputBands != null && !(this.outputBands instanceof SdkAutoConstructList);
    }

    public final List<OutputBand> outputBands() {
        return this.outputBands;
    }

    public final EarthObservationJobStatus status() {
        return EarthObservationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportErrorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputBands() ? this.outputBands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEarthObservationJobResponse)) {
            return false;
        }
        GetEarthObservationJobResponse other = (GetEarthObservationJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.exportErrorDetails(), other.exportErrorDetails()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.jobConfig(), other.jobConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.name(), other.name()) && this.hasOutputBands() == other.hasOutputBands() && Objects.equals(this.outputBands(), other.outputBands()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetEarthObservationJobResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("ErrorDetails", (Object)this.errorDetails()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ExportErrorDetails", (Object)this.exportErrorDetails()).add("ExportStatus", (Object)this.exportStatusAsString()).add("InputConfig", (Object)this.inputConfig()).add("JobConfig", (Object)this.jobConfig()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Name", (Object)this.name()).add("OutputBands", this.hasOutputBands() ? this.outputBands() : null).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ExportErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.exportErrorDetails()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "JobConfig": {
                return Optional.ofNullable(clazz.cast(this.jobConfig()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OutputBands": {
                return Optional.ofNullable(clazz.cast(this.outputBands()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ExportErrorDetails", EXPORT_ERROR_DETAILS_FIELD);
        map.put("ExportStatus", EXPORT_STATUS_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("JobConfig", JOB_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OutputBands", OUTPUT_BANDS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEarthObservationJobResponse, T> g) {
        return obj -> g.apply((GetEarthObservationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private Integer durationInSeconds;
        private EarthObservationJobErrorDetails errorDetails;
        private String executionRoleArn;
        private ExportErrorDetails exportErrorDetails;
        private String exportStatus;
        private InputConfigOutput inputConfig;
        private JobConfigInput jobConfig;
        private String kmsKeyId;
        private String name;
        private List<OutputBand> outputBands = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEarthObservationJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.durationInSeconds(model.durationInSeconds);
            this.errorDetails(model.errorDetails);
            this.executionRoleArn(model.executionRoleArn);
            this.exportErrorDetails(model.exportErrorDetails);
            this.exportStatus(model.exportStatus);
            this.inputConfig(model.inputConfig);
            this.jobConfig(model.jobConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.name(model.name);
            this.outputBands(model.outputBands);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final EarthObservationJobErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(EarthObservationJobErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(EarthObservationJobErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final ExportErrorDetails.Builder getExportErrorDetails() {
            return this.exportErrorDetails != null ? this.exportErrorDetails.toBuilder() : null;
        }

        public final void setExportErrorDetails(ExportErrorDetails.BuilderImpl exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails != null ? exportErrorDetails.build() : null;
        }

        @Override
        public final Builder exportErrorDetails(ExportErrorDetails exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails;
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(EarthObservationJobExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final InputConfigOutput.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(InputConfigOutput.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(InputConfigOutput inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final JobConfigInput.Builder getJobConfig() {
            return this.jobConfig != null ? this.jobConfig.toBuilder() : null;
        }

        public final void setJobConfig(JobConfigInput.BuilderImpl jobConfig) {
            this.jobConfig = jobConfig != null ? jobConfig.build() : null;
        }

        @Override
        public final Builder jobConfig(JobConfigInput jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<OutputBand.Builder> getOutputBands() {
            List<OutputBand.Builder> result = EarthObservationJobOutputBandsCopier.copyToBuilder(this.outputBands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputBands(Collection<OutputBand.BuilderImpl> outputBands) {
            this.outputBands = EarthObservationJobOutputBandsCopier.copyFromBuilder(outputBands);
        }

        @Override
        public final Builder outputBands(Collection<OutputBand> outputBands) {
            this.outputBands = EarthObservationJobOutputBandsCopier.copy(outputBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputBands(OutputBand ... outputBands) {
            this.outputBands(Arrays.asList(outputBands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputBands(Consumer<OutputBand.Builder> ... outputBands) {
            this.outputBands(Stream.of(outputBands).map(c -> (OutputBand)((OutputBand.Builder)OutputBand.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EarthObservationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetEarthObservationJobResponse build() {
            return new GetEarthObservationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEarthObservationJobResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder durationInSeconds(Integer var1);

        public Builder errorDetails(EarthObservationJobErrorDetails var1);

        default public Builder errorDetails(Consumer<EarthObservationJobErrorDetails.Builder> errorDetails) {
            return this.errorDetails((EarthObservationJobErrorDetails)((EarthObservationJobErrorDetails.Builder)EarthObservationJobErrorDetails.builder().applyMutation(errorDetails)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder exportErrorDetails(ExportErrorDetails var1);

        default public Builder exportErrorDetails(Consumer<ExportErrorDetails.Builder> exportErrorDetails) {
            return this.exportErrorDetails((ExportErrorDetails)((ExportErrorDetails.Builder)ExportErrorDetails.builder().applyMutation(exportErrorDetails)).build());
        }

        public Builder exportStatus(String var1);

        public Builder exportStatus(EarthObservationJobExportStatus var1);

        public Builder inputConfig(InputConfigOutput var1);

        default public Builder inputConfig(Consumer<InputConfigOutput.Builder> inputConfig) {
            return this.inputConfig((InputConfigOutput)((InputConfigOutput.Builder)InputConfigOutput.builder().applyMutation(inputConfig)).build());
        }

        public Builder jobConfig(JobConfigInput var1);

        default public Builder jobConfig(Consumer<JobConfigInput.Builder> jobConfig) {
            return this.jobConfig((JobConfigInput)((JobConfigInput.Builder)JobConfigInput.builder().applyMutation(jobConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder name(String var1);

        public Builder outputBands(Collection<OutputBand> var1);

        public Builder outputBands(OutputBand ... var1);

        public Builder outputBands(Consumer<OutputBand.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(EarthObservationJobStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

