/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataCollectionType {
    PUBLIC("PUBLIC"),
    PREMIUM("PREMIUM"),
    USER("USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataCollectionType> VALUE_MAP;
    private final String value;

    private DataCollectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataCollectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataCollectionType> knownValues() {
        EnumSet<DataCollectionType> knownValues = EnumSet.allOf(DataCollectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataCollectionType.class, DataCollectionType::toString);
    }
}

