/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialClient;
import software.amazon.awssdk.services.sagemakergeospatial.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListRasterDataCollectionsResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.RasterDataCollectionMetadata;

public class ListRasterDataCollectionsIterable
implements SdkIterable<ListRasterDataCollectionsResponse> {
    private final SageMakerGeospatialClient client;
    private final ListRasterDataCollectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRasterDataCollectionsIterable(SageMakerGeospatialClient client, ListRasterDataCollectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRasterDataCollectionsResponseFetcher();
    }

    public Iterator<ListRasterDataCollectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RasterDataCollectionMetadata> rasterDataCollectionSummaries() {
        Function<ListRasterDataCollectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rasterDataCollectionSummaries() != null) {
                return response.rasterDataCollectionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRasterDataCollectionsResponseFetcher
    implements SyncPageFetcher<ListRasterDataCollectionsResponse> {
        private ListRasterDataCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRasterDataCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRasterDataCollectionsResponse nextPage(ListRasterDataCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListRasterDataCollectionsIterable.this.client.listRasterDataCollections(ListRasterDataCollectionsIterable.this.firstRequest);
            }
            return ListRasterDataCollectionsIterable.this.client.listRasterDataCollections((ListRasterDataCollectionsRequest)((Object)ListRasterDataCollectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

