/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.AssetValue;
import software.amazon.awssdk.services.sagemakergeospatial.model.AssetsMapCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.Geometry;
import software.amazon.awssdk.services.sagemakergeospatial.model.Properties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemSource> {
    private static final SdkField<Map<String, AssetValue>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Assets").getter(ItemSource.getter(ItemSource::assets)).setter(ItemSource.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateTime").getter(ItemSource.getter(ItemSource::dateTime)).setter(ItemSource.setter(Builder::dateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTime").build()}).build();
    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(ItemSource.getter(ItemSource::geometry)).setter(ItemSource.setter(Builder::geometry)).constructor(Geometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ItemSource.getter(ItemSource::id)).setter(ItemSource.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Properties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Properties").getter(ItemSource.getter(ItemSource::properties)).setter(ItemSource.setter(Builder::properties)).constructor(Properties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD, DATE_TIME_FIELD, GEOMETRY_FIELD, ID_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ItemSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, AssetValue> assets;
    private final Instant dateTime;
    private final Geometry geometry;
    private final String id;
    private final Properties properties;

    private ItemSource(BuilderImpl builder) {
        this.assets = builder.assets;
        this.dateTime = builder.dateTime;
        this.geometry = builder.geometry;
        this.id = builder.id;
        this.properties = builder.properties;
    }

    public final boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructMap);
    }

    public final Map<String, AssetValue> assets() {
        return this.assets;
    }

    public final Instant dateTime() {
        return this.dateTime;
    }

    public final Geometry geometry() {
        return this.geometry;
    }

    public final String id() {
        return this.id;
    }

    public final Properties properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemSource)) {
            return false;
        }
        ItemSource other = (ItemSource)obj;
        return this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets()) && Objects.equals(this.dateTime(), other.dateTime()) && Objects.equals(this.geometry(), other.geometry()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"ItemSource").add("Assets", this.hasAssets() ? this.assets() : null).add("DateTime", (Object)this.dateTime()).add("Geometry", (Object)this.geometry()).add("Id", (Object)this.id()).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
            case "DateTime": {
                return Optional.ofNullable(clazz.cast(this.dateTime()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Assets", ASSETS_FIELD);
        map.put("DateTime", DATE_TIME_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemSource, T> g) {
        return obj -> g.apply((ItemSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AssetValue> assets = DefaultSdkAutoConstructMap.getInstance();
        private Instant dateTime;
        private Geometry geometry;
        private String id;
        private Properties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemSource model) {
            this.assets(model.assets);
            this.dateTime(model.dateTime);
            this.geometry(model.geometry);
            this.id(model.id);
            this.properties(model.properties);
        }

        public final Map<String, AssetValue.Builder> getAssets() {
            Map<String, AssetValue.Builder> result = AssetsMapCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssets(Map<String, AssetValue.BuilderImpl> assets) {
            this.assets = AssetsMapCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Map<String, AssetValue> assets) {
            this.assets = AssetsMapCopier.copy(assets);
            return this;
        }

        public final Instant getDateTime() {
            return this.dateTime;
        }

        public final void setDateTime(Instant dateTime) {
            this.dateTime = dateTime;
        }

        @Override
        public final Builder dateTime(Instant dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Properties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(Properties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public ItemSource build() {
            return new ItemSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemSource> {
        public Builder assets(Map<String, AssetValue> var1);

        public Builder dateTime(Instant var1);

        public Builder geometry(Geometry var1);

        default public Builder geometry(Consumer<Geometry.Builder> geometry) {
            return this.geometry((Geometry)((Geometry.Builder)Geometry.builder().applyMutation(geometry)).build());
        }

        public Builder id(String var1);

        public Builder properties(Properties var1);

        default public Builder properties(Consumer<Properties.Builder> properties) {
            return this.properties((Properties)((Properties.Builder)Properties.builder().applyMutation(properties)).build());
        }
    }
}

