/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordErrorsCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetailsCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.UnprocessedIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRecordResponse
extends SageMakerFeatureStoreRuntimeResponse
implements ToCopyableBuilder<Builder, BatchGetRecordResponse> {
    private static final SdkField<List<BatchGetRecordResultDetail>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(BatchGetRecordResponse.getter(BatchGetRecordResponse::records)).setter(BatchGetRecordResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRecordResultDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetRecordError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetRecordResponse.getter(BatchGetRecordResponse::errors)).setter(BatchGetRecordResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRecordError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetRecordIdentifier>> UNPROCESSED_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedIdentifiers").getter(BatchGetRecordResponse.getter(BatchGetRecordResponse::unprocessedIdentifiers)).setter(BatchGetRecordResponse.setter(Builder::unprocessedIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetRecordIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, ERRORS_FIELD, UNPROCESSED_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetRecordResponse.memberNameToFieldInitializer();
    private final List<BatchGetRecordResultDetail> records;
    private final List<BatchGetRecordError> errors;
    private final List<BatchGetRecordIdentifier> unprocessedIdentifiers;

    private BatchGetRecordResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.errors = builder.errors;
        this.unprocessedIdentifiers = builder.unprocessedIdentifiers;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRecordResultDetail> records() {
        return this.records;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRecordError> errors() {
        return this.errors;
    }

    public final boolean hasUnprocessedIdentifiers() {
        return this.unprocessedIdentifiers != null && !(this.unprocessedIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<BatchGetRecordIdentifier> unprocessedIdentifiers() {
        return this.unprocessedIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedIdentifiers() ? this.unprocessedIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRecordResponse)) {
            return false;
        }
        BatchGetRecordResponse other = (BatchGetRecordResponse)((Object)obj);
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasUnprocessedIdentifiers() == other.hasUnprocessedIdentifiers() && Objects.equals(this.unprocessedIdentifiers(), other.unprocessedIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRecordResponse").add("Records", this.hasRecords() ? this.records() : null).add("Errors", this.hasErrors() ? this.errors() : null).add("UnprocessedIdentifiers", this.hasUnprocessedIdentifiers() ? this.unprocessedIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "UnprocessedIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.unprocessedIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Records", RECORDS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("UnprocessedIdentifiers", UNPROCESSED_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRecordResponse, T> g) {
        return obj -> g.apply((BatchGetRecordResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerFeatureStoreRuntimeResponse.BuilderImpl
    implements Builder {
        private List<BatchGetRecordResultDetail> records = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetRecordError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetRecordIdentifier> unprocessedIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRecordResponse model) {
            super(model);
            this.records(model.records);
            this.errors(model.errors);
            this.unprocessedIdentifiers(model.unprocessedIdentifiers);
        }

        public final List<BatchGetRecordResultDetail.Builder> getRecords() {
            List<BatchGetRecordResultDetail.Builder> result = BatchGetRecordResultDetailsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<BatchGetRecordResultDetail.BuilderImpl> records) {
            this.records = BatchGetRecordResultDetailsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<BatchGetRecordResultDetail> records) {
            this.records = BatchGetRecordResultDetailsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(BatchGetRecordResultDetail ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<BatchGetRecordResultDetail.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (BatchGetRecordResultDetail)((BatchGetRecordResultDetail.Builder)BatchGetRecordResultDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRecordError.Builder> getErrors() {
            List<BatchGetRecordError.Builder> result = BatchGetRecordErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRecordError.BuilderImpl> errors) {
            this.errors = BatchGetRecordErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRecordError> errors) {
            this.errors = BatchGetRecordErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRecordError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRecordError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetRecordError)((BatchGetRecordError.Builder)BatchGetRecordError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRecordIdentifier.Builder> getUnprocessedIdentifiers() {
            List<BatchGetRecordIdentifier.Builder> result = UnprocessedIdentifiersCopier.copyToBuilder(this.unprocessedIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedIdentifiers(Collection<BatchGetRecordIdentifier.BuilderImpl> unprocessedIdentifiers) {
            this.unprocessedIdentifiers = UnprocessedIdentifiersCopier.copyFromBuilder(unprocessedIdentifiers);
        }

        @Override
        public final Builder unprocessedIdentifiers(Collection<BatchGetRecordIdentifier> unprocessedIdentifiers) {
            this.unprocessedIdentifiers = UnprocessedIdentifiersCopier.copy(unprocessedIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentifiers(BatchGetRecordIdentifier ... unprocessedIdentifiers) {
            this.unprocessedIdentifiers(Arrays.asList(unprocessedIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentifiers(Consumer<BatchGetRecordIdentifier.Builder> ... unprocessedIdentifiers) {
            this.unprocessedIdentifiers(Stream.of(unprocessedIdentifiers).map(c -> (BatchGetRecordIdentifier)((BatchGetRecordIdentifier.Builder)BatchGetRecordIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRecordResponse build() {
            return new BatchGetRecordResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerFeatureStoreRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRecordResponse> {
        public Builder records(Collection<BatchGetRecordResultDetail> var1);

        public Builder records(BatchGetRecordResultDetail ... var1);

        public Builder records(Consumer<BatchGetRecordResultDetail.Builder> ... var1);

        public Builder errors(Collection<BatchGetRecordError> var1);

        public Builder errors(BatchGetRecordError ... var1);

        public Builder errors(Consumer<BatchGetRecordError.Builder> ... var1);

        public Builder unprocessedIdentifiers(Collection<BatchGetRecordIdentifier> var1);

        public Builder unprocessedIdentifiers(BatchGetRecordIdentifier ... var1);

        public Builder unprocessedIdentifiers(Consumer<BatchGetRecordIdentifier.Builder> ... var1);
    }
}

