/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakeredge.model.DeploymentModel;
import software.amazon.awssdk.services.sagemakeredge.model.DeploymentModelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentResult> {
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentName").getter(DeploymentResult.getter(DeploymentResult::deploymentName)).setter(DeploymentResult.setter(Builder::deploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(DeploymentResult.getter(DeploymentResult::deploymentStatus)).setter(DeploymentResult.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatusMessage").getter(DeploymentResult.getter(DeploymentResult::deploymentStatusMessage)).setter(DeploymentResult.setter(Builder::deploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatusMessage").build()}).build();
    private static final SdkField<Instant> DEPLOYMENT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeploymentStartTime").getter(DeploymentResult.getter(DeploymentResult::deploymentStartTime)).setter(DeploymentResult.setter(Builder::deploymentStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStartTime").build()}).build();
    private static final SdkField<Instant> DEPLOYMENT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeploymentEndTime").getter(DeploymentResult.getter(DeploymentResult::deploymentEndTime)).setter(DeploymentResult.setter(Builder::deploymentEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentEndTime").build()}).build();
    private static final SdkField<List<DeploymentModel>> DEPLOYMENT_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeploymentModels").getter(DeploymentResult.getter(DeploymentResult::deploymentModels)).setter(DeploymentResult.setter(Builder::deploymentModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_NAME_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_STATUS_MESSAGE_FIELD, DEPLOYMENT_START_TIME_FIELD, DEPLOYMENT_END_TIME_FIELD, DEPLOYMENT_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deploymentName;
    private final String deploymentStatus;
    private final String deploymentStatusMessage;
    private final Instant deploymentStartTime;
    private final Instant deploymentEndTime;
    private final List<DeploymentModel> deploymentModels;

    private DeploymentResult(BuilderImpl builder) {
        this.deploymentName = builder.deploymentName;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentStatusMessage = builder.deploymentStatusMessage;
        this.deploymentStartTime = builder.deploymentStartTime;
        this.deploymentEndTime = builder.deploymentEndTime;
        this.deploymentModels = builder.deploymentModels;
    }

    public final String deploymentName() {
        return this.deploymentName;
    }

    public final String deploymentStatus() {
        return this.deploymentStatus;
    }

    public final String deploymentStatusMessage() {
        return this.deploymentStatusMessage;
    }

    public final Instant deploymentStartTime() {
        return this.deploymentStartTime;
    }

    public final Instant deploymentEndTime() {
        return this.deploymentEndTime;
    }

    public final boolean hasDeploymentModels() {
        return this.deploymentModels != null && !(this.deploymentModels instanceof SdkAutoConstructList);
    }

    public final List<DeploymentModel> deploymentModels() {
        return this.deploymentModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentModels() ? this.deploymentModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentResult)) {
            return false;
        }
        DeploymentResult other = (DeploymentResult)obj;
        return Objects.equals(this.deploymentName(), other.deploymentName()) && Objects.equals(this.deploymentStatus(), other.deploymentStatus()) && Objects.equals(this.deploymentStatusMessage(), other.deploymentStatusMessage()) && Objects.equals(this.deploymentStartTime(), other.deploymentStartTime()) && Objects.equals(this.deploymentEndTime(), other.deploymentEndTime()) && this.hasDeploymentModels() == other.hasDeploymentModels() && Objects.equals(this.deploymentModels(), other.deploymentModels());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentResult").add("DeploymentName", (Object)this.deploymentName()).add("DeploymentStatus", (Object)this.deploymentStatus()).add("DeploymentStatusMessage", (Object)this.deploymentStatusMessage()).add("DeploymentStartTime", (Object)this.deploymentStartTime()).add("DeploymentEndTime", (Object)this.deploymentEndTime()).add("DeploymentModels", this.hasDeploymentModels() ? this.deploymentModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentName": {
                return Optional.ofNullable(clazz.cast(this.deploymentName()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatus()));
            }
            case "DeploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusMessage()));
            }
            case "DeploymentStartTime": {
                return Optional.ofNullable(clazz.cast(this.deploymentStartTime()));
            }
            case "DeploymentEndTime": {
                return Optional.ofNullable(clazz.cast(this.deploymentEndTime()));
            }
            case "DeploymentModels": {
                return Optional.ofNullable(clazz.cast(this.deploymentModels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeploymentName", DEPLOYMENT_NAME_FIELD);
        map.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("DeploymentStatusMessage", DEPLOYMENT_STATUS_MESSAGE_FIELD);
        map.put("DeploymentStartTime", DEPLOYMENT_START_TIME_FIELD);
        map.put("DeploymentEndTime", DEPLOYMENT_END_TIME_FIELD);
        map.put("DeploymentModels", DEPLOYMENT_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentResult, T> g) {
        return obj -> g.apply((DeploymentResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentName;
        private String deploymentStatus;
        private String deploymentStatusMessage;
        private Instant deploymentStartTime;
        private Instant deploymentEndTime;
        private List<DeploymentModel> deploymentModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentResult model) {
            this.deploymentName(model.deploymentName);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentStatusMessage(model.deploymentStatusMessage);
            this.deploymentStartTime(model.deploymentStartTime);
            this.deploymentEndTime(model.deploymentEndTime);
            this.deploymentModels(model.deploymentModels);
        }

        public final String getDeploymentName() {
            return this.deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public final String getDeploymentStatusMessage() {
            return this.deploymentStatusMessage;
        }

        public final void setDeploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
        }

        @Override
        public final Builder deploymentStatusMessage(String deploymentStatusMessage) {
            this.deploymentStatusMessage = deploymentStatusMessage;
            return this;
        }

        public final Instant getDeploymentStartTime() {
            return this.deploymentStartTime;
        }

        public final void setDeploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
        }

        @Override
        public final Builder deploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
            return this;
        }

        public final Instant getDeploymentEndTime() {
            return this.deploymentEndTime;
        }

        public final void setDeploymentEndTime(Instant deploymentEndTime) {
            this.deploymentEndTime = deploymentEndTime;
        }

        @Override
        public final Builder deploymentEndTime(Instant deploymentEndTime) {
            this.deploymentEndTime = deploymentEndTime;
            return this;
        }

        public final List<DeploymentModel.Builder> getDeploymentModels() {
            List<DeploymentModel.Builder> result = DeploymentModelsCopier.copyToBuilder(this.deploymentModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentModels(Collection<DeploymentModel.BuilderImpl> deploymentModels) {
            this.deploymentModels = DeploymentModelsCopier.copyFromBuilder(deploymentModels);
        }

        @Override
        public final Builder deploymentModels(Collection<DeploymentModel> deploymentModels) {
            this.deploymentModels = DeploymentModelsCopier.copy(deploymentModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentModels(DeploymentModel ... deploymentModels) {
            this.deploymentModels(Arrays.asList(deploymentModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentModels(Consumer<DeploymentModel.Builder> ... deploymentModels) {
            this.deploymentModels(Stream.of(deploymentModels).map(c -> (DeploymentModel)((DeploymentModel.Builder)DeploymentModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DeploymentResult build() {
            return new DeploymentResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentResult> {
        public Builder deploymentName(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatusMessage(String var1);

        public Builder deploymentStartTime(Instant var1);

        public Builder deploymentEndTime(Instant var1);

        public Builder deploymentModels(Collection<DeploymentModel> var1);

        public Builder deploymentModels(DeploymentModel ... var1);

        public Builder deploymentModels(Consumer<DeploymentModel.Builder> ... var1);
    }
}

