/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakeredge.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelState {
    DEPLOY("DEPLOY"),
    UNDEPLOY("UNDEPLOY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelState> VALUE_MAP;
    private final String value;

    private ModelState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelState> knownValues() {
        EnumSet<ModelState> knownValues = EnumSet.allOf(ModelState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelState.class, ModelState::toString);
    }
}

