/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummary;

public class ListPipelineVersionsPublisher
implements SdkPublisher<ListPipelineVersionsResponse> {
    private final SageMakerAsyncClient client;
    private final ListPipelineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelineVersionsPublisher(SageMakerAsyncClient client, ListPipelineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelineVersionsPublisher(SageMakerAsyncClient client, ListPipelineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelineVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelineVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PipelineVersionSummary> pipelineVersionSummaries() {
        Function<ListPipelineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineVersionSummaries() != null) {
                return response.pipelineVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelineVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipelineVersionsResponseFetcher
    implements AsyncPageFetcher<ListPipelineVersionsResponse> {
        private ListPipelineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelineVersionsResponse> nextPage(ListPipelineVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineVersionsPublisher.this.client.listPipelineVersions(ListPipelineVersionsPublisher.this.firstRequest);
            }
            return ListPipelineVersionsPublisher.this.client.listPipelineVersions((ListPipelineVersionsRequest)((Object)ListPipelineVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

