/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.MlflowAppSummary;

public class ListMlflowAppsIterable
implements SdkIterable<ListMlflowAppsResponse> {
    private final SageMakerClient client;
    private final ListMlflowAppsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMlflowAppsIterable(SageMakerClient client, ListMlflowAppsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMlflowAppsResponseFetcher();
    }

    public Iterator<ListMlflowAppsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MlflowAppSummary> summaries() {
        Function<ListMlflowAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMlflowAppsResponseFetcher
    implements SyncPageFetcher<ListMlflowAppsResponse> {
        private ListMlflowAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListMlflowAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMlflowAppsResponse nextPage(ListMlflowAppsResponse previousPage) {
            if (previousPage == null) {
                return ListMlflowAppsIterable.this.client.listMlflowApps(ListMlflowAppsIterable.this.firstRequest);
            }
            return ListMlflowAppsIterable.this.client.listMlflowApps((ListMlflowAppsRequest)((Object)ListMlflowAppsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

