/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.AuthorizedUrl;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsResponse;

public class CreateHubContentPresignedUrlsPublisher
implements SdkPublisher<CreateHubContentPresignedUrlsResponse> {
    private final SageMakerAsyncClient client;
    private final CreateHubContentPresignedUrlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public CreateHubContentPresignedUrlsPublisher(SageMakerAsyncClient client, CreateHubContentPresignedUrlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private CreateHubContentPresignedUrlsPublisher(SageMakerAsyncClient client, CreateHubContentPresignedUrlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new CreateHubContentPresignedUrlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super CreateHubContentPresignedUrlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuthorizedUrl> authorizedUrlConfigs() {
        Function<CreateHubContentPresignedUrlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.authorizedUrlConfigs() != null) {
                return response.authorizedUrlConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new CreateHubContentPresignedUrlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class CreateHubContentPresignedUrlsResponseFetcher
    implements AsyncPageFetcher<CreateHubContentPresignedUrlsResponse> {
        private CreateHubContentPresignedUrlsResponseFetcher() {
        }

        public boolean hasNextPage(CreateHubContentPresignedUrlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<CreateHubContentPresignedUrlsResponse> nextPage(CreateHubContentPresignedUrlsResponse previousPage) {
            if (previousPage == null) {
                return CreateHubContentPresignedUrlsPublisher.this.client.createHubContentPresignedUrls(CreateHubContentPresignedUrlsPublisher.this.firstRequest);
            }
            return CreateHubContentPresignedUrlsPublisher.this.client.createHubContentPresignedUrls((CreateHubContentPresignedUrlsRequest)((Object)CreateHubContentPresignedUrlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

