/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingJobStatus {
    IN_PROGRESS("InProgress"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    DELETING("Deleting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingJobStatus> VALUE_MAP;
    private final String value;

    private TrainingJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingJobStatus> knownValues() {
        EnumSet<TrainingJobStatus> knownValues = EnumSet.allOf(TrainingJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingJobStatus.class, TrainingJobStatus::toString);
    }
}

