/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipelineVersionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdatePipelineVersionRequest> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(UpdatePipelineVersionRequest.getter(UpdatePipelineVersionRequest::pipelineArn)).setter(UpdatePipelineVersionRequest.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<Long> PIPELINE_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PipelineVersionId").getter(UpdatePipelineVersionRequest.getter(UpdatePipelineVersionRequest::pipelineVersionId)).setter(UpdatePipelineVersionRequest.setter(Builder::pipelineVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionId").build()}).build();
    private static final SdkField<String> PIPELINE_VERSION_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineVersionDisplayName").getter(UpdatePipelineVersionRequest.getter(UpdatePipelineVersionRequest::pipelineVersionDisplayName)).setter(UpdatePipelineVersionRequest.setter(Builder::pipelineVersionDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDisplayName").build()}).build();
    private static final SdkField<String> PIPELINE_VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineVersionDescription").getter(UpdatePipelineVersionRequest.getter(UpdatePipelineVersionRequest::pipelineVersionDescription)).setter(UpdatePipelineVersionRequest.setter(Builder::pipelineVersionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD, PIPELINE_VERSION_ID_FIELD, PIPELINE_VERSION_DISPLAY_NAME_FIELD, PIPELINE_VERSION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePipelineVersionRequest.memberNameToFieldInitializer();
    private final String pipelineArn;
    private final Long pipelineVersionId;
    private final String pipelineVersionDisplayName;
    private final String pipelineVersionDescription;

    private UpdatePipelineVersionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.pipelineVersionId = builder.pipelineVersionId;
        this.pipelineVersionDisplayName = builder.pipelineVersionDisplayName;
        this.pipelineVersionDescription = builder.pipelineVersionDescription;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final Long pipelineVersionId() {
        return this.pipelineVersionId;
    }

    public final String pipelineVersionDisplayName() {
        return this.pipelineVersionDisplayName;
    }

    public final String pipelineVersionDescription() {
        return this.pipelineVersionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersionDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersionDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineVersionRequest)) {
            return false;
        }
        UpdatePipelineVersionRequest other = (UpdatePipelineVersionRequest)((Object)obj);
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.pipelineVersionId(), other.pipelineVersionId()) && Objects.equals(this.pipelineVersionDisplayName(), other.pipelineVersionDisplayName()) && Objects.equals(this.pipelineVersionDescription(), other.pipelineVersionDescription());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipelineVersionRequest").add("PipelineArn", (Object)this.pipelineArn()).add("PipelineVersionId", (Object)this.pipelineVersionId()).add("PipelineVersionDisplayName", (Object)this.pipelineVersionDisplayName()).add("PipelineVersionDescription", (Object)this.pipelineVersionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "PipelineVersionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersionId()));
            }
            case "PipelineVersionDisplayName": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersionDisplayName()));
            }
            case "PipelineVersionDescription": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersionDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("PipelineVersionId", PIPELINE_VERSION_ID_FIELD);
        map.put("PipelineVersionDisplayName", PIPELINE_VERSION_DISPLAY_NAME_FIELD);
        map.put("PipelineVersionDescription", PIPELINE_VERSION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineVersionRequest, T> g) {
        return obj -> g.apply((UpdatePipelineVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String pipelineArn;
        private Long pipelineVersionId;
        private String pipelineVersionDisplayName;
        private String pipelineVersionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineVersionRequest model) {
            super(model);
            this.pipelineArn(model.pipelineArn);
            this.pipelineVersionId(model.pipelineVersionId);
            this.pipelineVersionDisplayName(model.pipelineVersionDisplayName);
            this.pipelineVersionDescription(model.pipelineVersionDescription);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Long getPipelineVersionId() {
            return this.pipelineVersionId;
        }

        public final void setPipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
        }

        @Override
        public final Builder pipelineVersionId(Long pipelineVersionId) {
            this.pipelineVersionId = pipelineVersionId;
            return this;
        }

        public final String getPipelineVersionDisplayName() {
            return this.pipelineVersionDisplayName;
        }

        public final void setPipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
        }

        @Override
        public final Builder pipelineVersionDisplayName(String pipelineVersionDisplayName) {
            this.pipelineVersionDisplayName = pipelineVersionDisplayName;
            return this;
        }

        public final String getPipelineVersionDescription() {
            return this.pipelineVersionDescription;
        }

        public final void setPipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
        }

        @Override
        public final Builder pipelineVersionDescription(String pipelineVersionDescription) {
            this.pipelineVersionDescription = pipelineVersionDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineVersionRequest build() {
            return new UpdatePipelineVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePipelineVersionRequest> {
        public Builder pipelineArn(String var1);

        public Builder pipelineVersionId(Long var1);

        public Builder pipelineVersionDisplayName(String var1);

        public Builder pipelineVersionDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

