/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingProgressInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingProgressInfo> {
    private static final SdkField<Long> TOTAL_STEP_COUNT_PER_EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalStepCountPerEpoch").getter(TrainingProgressInfo.getter(TrainingProgressInfo::totalStepCountPerEpoch)).setter(TrainingProgressInfo.setter(Builder::totalStepCountPerEpoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalStepCountPerEpoch").build()}).build();
    private static final SdkField<Long> CURRENT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentStep").getter(TrainingProgressInfo.getter(TrainingProgressInfo::currentStep)).setter(TrainingProgressInfo.setter(Builder::currentStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStep").build()}).build();
    private static final SdkField<Long> CURRENT_EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentEpoch").getter(TrainingProgressInfo.getter(TrainingProgressInfo::currentEpoch)).setter(TrainingProgressInfo.setter(Builder::currentEpoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentEpoch").build()}).build();
    private static final SdkField<Long> MAX_EPOCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxEpoch").getter(TrainingProgressInfo.getter(TrainingProgressInfo::maxEpoch)).setter(TrainingProgressInfo.setter(Builder::maxEpoch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEpoch").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_STEP_COUNT_PER_EPOCH_FIELD, CURRENT_STEP_FIELD, CURRENT_EPOCH_FIELD, MAX_EPOCH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrainingProgressInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long totalStepCountPerEpoch;
    private final Long currentStep;
    private final Long currentEpoch;
    private final Long maxEpoch;

    private TrainingProgressInfo(BuilderImpl builder) {
        this.totalStepCountPerEpoch = builder.totalStepCountPerEpoch;
        this.currentStep = builder.currentStep;
        this.currentEpoch = builder.currentEpoch;
        this.maxEpoch = builder.maxEpoch;
    }

    public final Long totalStepCountPerEpoch() {
        return this.totalStepCountPerEpoch;
    }

    public final Long currentStep() {
        return this.currentStep;
    }

    public final Long currentEpoch() {
        return this.currentEpoch;
    }

    public final Long maxEpoch() {
        return this.maxEpoch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStepCountPerEpoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentEpoch());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEpoch());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingProgressInfo)) {
            return false;
        }
        TrainingProgressInfo other = (TrainingProgressInfo)obj;
        return Objects.equals(this.totalStepCountPerEpoch(), other.totalStepCountPerEpoch()) && Objects.equals(this.currentStep(), other.currentStep()) && Objects.equals(this.currentEpoch(), other.currentEpoch()) && Objects.equals(this.maxEpoch(), other.maxEpoch());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingProgressInfo").add("TotalStepCountPerEpoch", (Object)this.totalStepCountPerEpoch()).add("CurrentStep", (Object)this.currentStep()).add("CurrentEpoch", (Object)this.currentEpoch()).add("MaxEpoch", (Object)this.maxEpoch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalStepCountPerEpoch": {
                return Optional.ofNullable(clazz.cast(this.totalStepCountPerEpoch()));
            }
            case "CurrentStep": {
                return Optional.ofNullable(clazz.cast(this.currentStep()));
            }
            case "CurrentEpoch": {
                return Optional.ofNullable(clazz.cast(this.currentEpoch()));
            }
            case "MaxEpoch": {
                return Optional.ofNullable(clazz.cast(this.maxEpoch()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("TotalStepCountPerEpoch", TOTAL_STEP_COUNT_PER_EPOCH_FIELD);
        map.put("CurrentStep", CURRENT_STEP_FIELD);
        map.put("CurrentEpoch", CURRENT_EPOCH_FIELD);
        map.put("MaxEpoch", MAX_EPOCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingProgressInfo, T> g) {
        return obj -> g.apply((TrainingProgressInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalStepCountPerEpoch;
        private Long currentStep;
        private Long currentEpoch;
        private Long maxEpoch;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingProgressInfo model) {
            this.totalStepCountPerEpoch(model.totalStepCountPerEpoch);
            this.currentStep(model.currentStep);
            this.currentEpoch(model.currentEpoch);
            this.maxEpoch(model.maxEpoch);
        }

        public final Long getTotalStepCountPerEpoch() {
            return this.totalStepCountPerEpoch;
        }

        public final void setTotalStepCountPerEpoch(Long totalStepCountPerEpoch) {
            this.totalStepCountPerEpoch = totalStepCountPerEpoch;
        }

        @Override
        public final Builder totalStepCountPerEpoch(Long totalStepCountPerEpoch) {
            this.totalStepCountPerEpoch = totalStepCountPerEpoch;
            return this;
        }

        public final Long getCurrentStep() {
            return this.currentStep;
        }

        public final void setCurrentStep(Long currentStep) {
            this.currentStep = currentStep;
        }

        @Override
        public final Builder currentStep(Long currentStep) {
            this.currentStep = currentStep;
            return this;
        }

        public final Long getCurrentEpoch() {
            return this.currentEpoch;
        }

        public final void setCurrentEpoch(Long currentEpoch) {
            this.currentEpoch = currentEpoch;
        }

        @Override
        public final Builder currentEpoch(Long currentEpoch) {
            this.currentEpoch = currentEpoch;
            return this;
        }

        public final Long getMaxEpoch() {
            return this.maxEpoch;
        }

        public final void setMaxEpoch(Long maxEpoch) {
            this.maxEpoch = maxEpoch;
        }

        @Override
        public final Builder maxEpoch(Long maxEpoch) {
            this.maxEpoch = maxEpoch;
            return this;
        }

        public TrainingProgressInfo build() {
            return new TrainingProgressInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingProgressInfo> {
        public Builder totalStepCountPerEpoch(Long var1);

        public Builder currentStep(Long var1);

        public Builder currentEpoch(Long var1);

        public Builder maxEpoch(Long var1);
    }
}

